/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.saaj.CommentImpl;
import org.apache.axis2.saaj.DetailImpl;
import org.apache.axis2.saaj.NodeListImpl;
import org.apache.axis2.saaj.SAAJDocument;
import org.apache.axis2.saaj.SOAPBodyImpl;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPFaultElementImpl;
import org.apache.axis2.saaj.SOAPFaultImpl;
import org.apache.axis2.saaj.SOAPHeaderElementImpl;
import org.apache.axis2.saaj.SOAPHeaderImpl;
import org.apache.axis2.saaj.TextImplEx;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class ProxyNode<T extends Node, S extends OMInformationItem>
implements Node {
    protected final T target;
    protected final S omTarget;
    static final String SAAJ_NODE = "saaj.node";

    public ProxyNode(T target, S omTarget) {
        this.target = target;
        this.omTarget = omTarget;
        target.setUserData(SAAJ_NODE, this, null);
    }

    public final T getTarget() {
        return this.target;
    }

    public final S getOMTarget() {
        return this.omTarget;
    }

    public void recycleNode() {
    }

    public void setType(int nodeType) throws OMException {
        throw new UnsupportedOperationException("TODO");
    }

    public int getType() {
        return this.getNodeType();
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("TODO");
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    Node toSAAJNode(Node domNode) {
        return ProxyNode.toSAAJNode(domNode, this);
    }

    static Node toSAAJNode(Node domNode, Node parentNode) {
        if (domNode == null) {
            return null;
        }
        Node saajNode = (Node)domNode.getUserData(SAAJ_NODE);
        if (saajNode == null) {
            return ProxyNode.toSAAJNode2(domNode, parentNode);
        }
        return saajNode;
    }

    private static Node toSAAJNode2(Node domNode, Node parentNode) {
        if (domNode == null) {
            return null;
        }
        if (domNode instanceof Text) {
            return new TextImplEx((OMNode)((OMText)domNode));
        }
        if (domNode instanceof Comment) {
            return new CommentImpl((OMComment)domNode);
        }
        if (domNode instanceof SOAPBody) {
            return new SOAPBodyImpl((SOAPBody)domNode);
        }
        if (domNode instanceof SOAPEnvelope) {
            return new SOAPEnvelopeImpl((SOAPEnvelope)domNode);
        }
        if (domNode instanceof SOAPFaultNode) {
            return new SOAPFaultElementImpl<SOAPFaultNode>((SOAPFaultNode)domNode);
        }
        if (domNode instanceof SOAPFaultDetail) {
            return new DetailImpl((SOAPFaultDetail)domNode);
        }
        if (domNode instanceof SOAPFault) {
            return new SOAPFaultImpl((SOAPFault)domNode);
        }
        if (domNode instanceof SOAPHeaderBlock) {
            return new SOAPHeaderElementImpl((SOAPHeaderBlock)domNode);
        }
        if (domNode instanceof SOAPHeader) {
            return new SOAPHeaderImpl((SOAPHeader)domNode);
        }
        if (domNode instanceof Document) {
            return new SAAJDocument((OMDocument)domNode);
        }
        return new SOAPElementImpl<OMElement>((OMElement)domNode);
    }

    @Override
    public Node getParentNode() {
        return this.toSAAJNode(this.target.getParentNode());
    }

    @Override
    public final boolean hasAttributes() {
        return this.target.hasAttributes();
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return this.target.isSupported(feature, version);
    }

    @Override
    public final String getBaseURI() {
        return this.target.getBaseURI();
    }

    @Override
    public final String getNodeValue() throws DOMException {
        return this.target.getNodeValue();
    }

    @Override
    public final void setNodeValue(String nodeValue) throws DOMException {
        this.target.setNodeValue(nodeValue);
    }

    @Override
    public final Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.target.insertBefore(newChild, refChild);
    }

    @Override
    public final Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.target.replaceChild(newChild, oldChild);
    }

    @Override
    public final Node cloneNode(boolean deep) {
        return this.target.cloneNode(deep);
    }

    @Override
    public final void normalize() {
        this.target.normalize();
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        this.target.setPrefix(prefix);
    }

    @Override
    public final short compareDocumentPosition(Node other) throws DOMException {
        return this.target.compareDocumentPosition(other);
    }

    @Override
    public final void setTextContent(String textContent) throws DOMException {
        this.target.setTextContent(textContent);
    }

    @Override
    public final boolean isSameNode(Node other) {
        return this.target.isSameNode(other);
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        return this.target.lookupPrefix(namespaceURI);
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        return this.target.isDefaultNamespace(namespaceURI);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public final boolean isEqualNode(Node arg) {
        return this.target.isEqualNode(arg);
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return this.target.getFeature(feature, version);
    }

    @Override
    public final Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.target.setUserData(key, data, handler);
    }

    @Override
    public final Object getUserData(String key) {
        return this.target.getUserData(key);
    }

    @Override
    public final Node removeChild(Node oldChild) throws DOMException {
        if (oldChild instanceof ProxyNode) {
            oldChild = ((ProxyNode)oldChild).getTarget();
        }
        return this.target.removeChild(oldChild);
    }

    @Override
    public final String getNodeName() {
        return this.target.getNodeName();
    }

    @Override
    public final short getNodeType() {
        return this.target.getNodeType();
    }

    @Override
    public final Document getOwnerDocument() {
        return (Document)this.toSAAJNode(this.target.getOwnerDocument());
    }

    @Override
    public final String getLocalName() {
        return this.target.getLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        return this.target.getNamespaceURI();
    }

    @Override
    public final String getPrefix() {
        return this.target.getPrefix();
    }

    @Override
    public final Node getFirstChild() {
        return this.toSAAJNode(this.target.getFirstChild());
    }

    @Override
    public final boolean hasChildNodes() {
        return this.target.hasChildNodes();
    }

    @Override
    public final Node getLastChild() {
        return this.toSAAJNode(this.target.getLastChild());
    }

    protected final NodeList toSAAJNodeList(NodeList nodes) {
        NodeListImpl result = new NodeListImpl();
        for (int i = 0; i < nodes.getLength(); ++i) {
            result.addNode(this.toSAAJNode(nodes.item(i)));
        }
        return result;
    }

    @Override
    public final NodeList getChildNodes() {
        return this.toSAAJNodeList(this.target.getChildNodes());
    }

    @Override
    public final Node appendChild(Node child) throws DOMException {
        if (this.getOwnerDocument() != child.getOwnerDocument()) {
            throw new DOMException(4, "Wrong document");
        }
        try {
            if (child instanceof Element) {
                return this.appendElement((Element)child);
            }
            this.target.appendChild((Node)((ProxyNode)child).target);
            return child;
        }
        catch (SOAPException e) {
            DOMException ex = new DOMException(3, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    protected Element appendElement(Element child) throws SOAPException {
        String namespaceURI = child.getNamespaceURI();
        String prefix = child.getPrefix();
        SOAPElementImpl childEle = (SOAPElementImpl)((Object)child);
        if (namespaceURI != null && namespaceURI.trim().length() > 0) {
            ((OMElement)childEle.omTarget).setNamespace(((OMElement)childEle.omTarget).declareNamespace(namespaceURI, prefix));
        }
        this.target.appendChild(childEle.target);
        childEle.setParentElement((SOAPElement)this);
        return childEle;
    }

    @Override
    public final String getTextContent() throws DOMException {
        return this.target.getTextContent();
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return this.target.getAttributes();
    }

    @Override
    public final Node getNextSibling() {
        return this.toSAAJNode(this.target.getNextSibling());
    }

    @Override
    public final Node getPreviousSibling() {
        return this.toSAAJNode(this.target.getPreviousSibling());
    }
}

