/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
//
// Generated By:JAX-WS RI IBM 2.1.1 in JDK 6 (JAXB RI IBM JAXB 2.1.3 in JDK 1.6)
//


package org.apache.axis2.jaxws.sample.asyncdoclit.client;

import java.util.concurrent.Future;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.Response;
import jakarta.xml.ws.ResponseWrapper;

import org.test.asyncdoclit.AnotherResponse;
import org.test.asyncdoclit.CustomAsyncResponse;
import org.test.asyncdoclit.ExceptionTypeEnum;
import org.test.asyncdoclit.InvokeAsyncResponse;
import org.test.asyncdoclit.PingResponse;
import org.test.asyncdoclit.SleepResponse;
import org.test.asyncdoclit.ThrowExceptionResponse;

@WebService(name = "AsyncPort", targetNamespace = "http://org/test/asyncdoclit")
public interface AsyncPort {


    /**
     * 
     * @param message
     * @return
     *     returns jakarta.xml.ws.Response<org.test.asyncdoclit.PingResponse>
     */
    @WebMethod(operationName = "ping", action = "ping")
    @RequestWrapper(localName = "ping", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Ping")
    @ResponseWrapper(localName = "pingResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.PingResponse")
    public Response<PingResponse> pingAsync(
        @WebParam(name = "message", targetNamespace = "")
        String message);

    /**
     * 
     * @param message
     * @param asyncHandler
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "ping", action = "ping")
    @RequestWrapper(localName = "ping", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Ping")
    @ResponseWrapper(localName = "pingResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.PingResponse")
    public Future<?> pingAsync(
        @WebParam(name = "message", targetNamespace = "")
        String message,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<PingResponse> asyncHandler);

    /**
     * 
     * @param message
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "ping")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "ping", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Ping")
    @ResponseWrapper(localName = "pingResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.PingResponse")
    public String ping(
        @WebParam(name = "message", targetNamespace = "")
        String message);

    /**
     * 
     * @param message
     * @return
     *     returns jakarta.xml.ws.Response<org.test.asyncdoclit.SleepResponse>
     */
    @WebMethod(operationName = "sleep", action = "sleep")
    @RequestWrapper(localName = "sleep", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Sleep")
    @ResponseWrapper(localName = "sleepResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.SleepResponse")
    public Response<SleepResponse> sleepAsync(
        @WebParam(name = "message", targetNamespace = "")
        String message);

    /**
     * 
     * @param message
     * @param asyncHandler
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "sleep", action = "sleep")
    @RequestWrapper(localName = "sleep", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Sleep")
    @ResponseWrapper(localName = "sleepResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.SleepResponse")
    public Future<?> sleepAsync(
        @WebParam(name = "message", targetNamespace = "")
        String message,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<SleepResponse> asyncHandler);

    /**
     * 
     * @param message
     */
    @WebMethod(action = "sleep")
    @RequestWrapper(localName = "sleep", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Sleep")
    @ResponseWrapper(localName = "sleepResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.SleepResponse")
    public void sleep(
        @WebParam(name = "message", targetNamespace = "", mode = WebParam.Mode.INOUT)
        Holder<String> message);

    /**
     * 
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "isAsleep")
    @WebResult(name = "message", targetNamespace = "")
    @RequestWrapper(localName = "isAsleep", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.IsAsleep")
    @ResponseWrapper(localName = "isAsleepResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.IsAsleepResponse")
    public String isAsleep();

    /**
     * 
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "wakeUp")
    @WebResult(name = "message", targetNamespace = "")
    @RequestWrapper(localName = "wakeUp", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.WakeUp")
    @ResponseWrapper(localName = "wakeUpResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.WakeUpResponse")
    public String wakeUp();

    /**
     * 
     * @param request
     * @return
     *     returns jakarta.xml.ws.Response<org.test.asyncdoclit.InvokeAsyncResponse>
     */
    @WebMethod(operationName = "invokeAsync", action = "invokeAsync")
    @RequestWrapper(localName = "invokeAsync", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.InvokeAsync")
    @ResponseWrapper(localName = "invokeAsyncResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.InvokeAsyncResponse")
    public Response<InvokeAsyncResponse> invokeAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param asyncHandler
     * @param request
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "invokeAsync", action = "invokeAsync")
    @RequestWrapper(localName = "invokeAsync", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.InvokeAsync")
    @ResponseWrapper(localName = "invokeAsyncResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.InvokeAsyncResponse")
    public Future<?> invokeAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<InvokeAsyncResponse> asyncHandler);

    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "invokeAsync")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "invokeAsync", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.InvokeAsync")
    @ResponseWrapper(localName = "invokeAsyncResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.InvokeAsyncResponse")
    public String invokeAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param request
     * @return
     *     returns jakarta.xml.ws.Response<org.test.asyncdoclit.CustomAsyncResponse>
     */
    @WebMethod(operationName = "customAsync", action = "customAsync")
    @RequestWrapper(localName = "customAsync", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.CustomAsync")
    @ResponseWrapper(localName = "customAsyncResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.CustomAsyncResponse")
    public Response<CustomAsyncResponse> remappedAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param asyncHandler
     * @param request
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "customAsync", action = "customAsync")
    @RequestWrapper(localName = "customAsync", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.CustomAsync")
    @ResponseWrapper(localName = "customAsyncResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.CustomAsyncResponse")
    public Future<?> remappedAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<CustomAsyncResponse> asyncHandler);

    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(operationName = "customAsync", action = "customAsync")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "customAsync", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.CustomAsync")
    @ResponseWrapper(localName = "customAsyncResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.CustomAsyncResponse")
    public String remapped(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param request
     * @return
     *     returns jakarta.xml.ws.Response<org.test.asyncdoclit.AnotherResponse>
     */
    @WebMethod(operationName = "another", action = "another")
    @RequestWrapper(localName = "another", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Another")
    @ResponseWrapper(localName = "anotherResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.AnotherResponse")
    public Response<AnotherResponse> anotherAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param asyncHandler
     * @param request
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "another", action = "another")
    @RequestWrapper(localName = "another", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Another")
    @ResponseWrapper(localName = "anotherResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.AnotherResponse")
    public Future<?> anotherAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<AnotherResponse> asyncHandler);

    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(operationName = "another", action = "another")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "another", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.Another")
    @ResponseWrapper(localName = "anotherResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.AnotherResponse")
    public String anotherAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param exceptionType
     * @return
     *     returns jakarta.xml.ws.Response<org.test.asyncdoclit.ThrowExceptionResponse>
     */
    @WebMethod(operationName = "throwException", action = "throwException")
    @RequestWrapper(localName = "throwException", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.ThrowException")
    @ResponseWrapper(localName = "throwExceptionResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.ThrowExceptionResponse")
    public Response<ThrowExceptionResponse> throwExceptionAsync(
        @WebParam(name = "exceptionType", targetNamespace = "")
        ExceptionTypeEnum exceptionType);

    /**
     * 
     * @param exceptionType
     * @param asyncHandler
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "throwException", action = "throwException")
    @RequestWrapper(localName = "throwException", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.ThrowException")
    @ResponseWrapper(localName = "throwExceptionResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.ThrowExceptionResponse")
    public Future<?> throwExceptionAsync(
        @WebParam(name = "exceptionType", targetNamespace = "")
        ExceptionTypeEnum exceptionType,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<ThrowExceptionResponse> asyncHandler);

    /**
     * 
     * @param exceptionType
     * @return
     *     returns java.lang.String
     * @throws ThrowExceptionFault
     */
    @WebMethod(action = "throwException")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "throwException", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.ThrowException")
    @ResponseWrapper(localName = "throwExceptionResponse", targetNamespace = "http://org/test/asyncdoclit", className = "org.test.asyncdoclit.ThrowExceptionResponse")
    public String throwException(
        @WebParam(name = "exceptionType", targetNamespace = "")
        ExceptionTypeEnum exceptionType)
        throws ThrowExceptionFault
    ;

}
