/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.engine.ObjectSupplier;

public class MultirefHelper {
    public static final String SOAP12_REF_ATTR = "ref";
    public static final String SOAP11_REF_ATTR = "href";
    private boolean filledTable;
    private OMElement parent;
    private HashMap objectmap = new HashMap();
    private HashMap elementMap = new HashMap();
    private HashMap omElementMap = new HashMap();

    public MultirefHelper(OMElement parent) {
        this.parent = parent;
    }

    public Object getObject(String id) {
        return this.objectmap.get(id);
    }

    public OMElement getOMElement(String id) {
        return (OMElement)this.omElementMap.get(id);
    }

    public OMElement processOMElementRef(String id) throws AxisFault {
        OMElement val;
        if (!this.filledTable) {
            this.readallChildElements();
        }
        if ((val = (OMElement)this.elementMap.get(id)) == null) {
            throw new AxisFault("Invalid reference :" + id);
        }
        OMElement ele = this.processElementforRefs(val);
        OMElement cloneele = this.elementClone(ele);
        this.omElementMap.put(id, cloneele);
        return cloneele;
    }

    public OMElement processElementforRefs(OMElement elemnts) throws AxisFault {
        Iterator itr = elemnts.getChildElements();
        while (itr.hasNext()) {
            OMElement omElement = (OMElement)itr.next();
            OMAttribute attri = MultirefHelper.processRefAtt(omElement);
            if (attri == null) continue;
            String ref = MultirefHelper.getAttvalue(attri);
            OMElement tempele = this.getOMElement(ref);
            if (tempele == null) {
                tempele = this.processOMElementRef(ref);
            }
            OMElement ele2 = this.elementClone(tempele);
            Iterator itrChild = ele2.getChildren();
            while (itrChild.hasNext()) {
                Object obj = itrChild.next();
                if (!(obj instanceof OMNode)) continue;
                itrChild.remove();
                omElement.addChild((OMNode)obj);
            }
        }
        return elemnts;
    }

    private OMElement elementClone(OMElement ele) {
        return OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)ele.getXMLStreamReader()).getDocumentElement();
    }

    public Object processRef(Class javatype, String id, ObjectSupplier objectSupplier) throws AxisFault {
        return this.processRef(javatype, null, id, objectSupplier);
    }

    public Object processRef(Class javatype, Type generictype, String id, ObjectSupplier objectSupplier) throws AxisFault {
        OMElement val;
        if (!this.filledTable) {
            this.readallChildElements();
        }
        if ((val = (OMElement)this.elementMap.get(id)) == null) {
            throw new AxisFault("Invalid reference :" + id);
        }
        if (SimpleTypeMapper.isSimpleType(javatype)) {
            Object valObj = SimpleTypeMapper.getSimpleTypeObject(javatype, val);
            this.objectmap.put(id, valObj);
            return valObj;
        }
        if (generictype != null && SimpleTypeMapper.isCollection(javatype)) {
            return BeanUtil.processGenericCollection(val.getFirstElement(), generictype, this, objectSupplier);
        }
        if (generictype != null && SimpleTypeMapper.isMap(javatype)) {
            Type[] parameterArgTypes = new Type[]{Object.class, Object.class};
            if (generictype instanceof ParameterizedType) {
                ParameterizedType aType = (ParameterizedType)generictype;
                parameterArgTypes = aType.getActualTypeArguments();
            }
            return BeanUtil.processGenericsMapElement(parameterArgTypes, val.getFirstElement(), this, val.getChildren(), objectSupplier, generictype);
        }
        Object obj = BeanUtil.deserialize(javatype, val, this, objectSupplier);
        this.objectmap.put(id, obj);
        return obj;
    }

    private void readallChildElements() {
        Iterator childs = this.parent.getChildElements();
        while (childs.hasNext()) {
            OMElement omElement = (OMElement)childs.next();
            OMAttribute id = omElement.getAttribute(new QName("id"));
            if (id == null) continue;
            childs.remove();
            this.elementMap.put(id.getAttributeValue(), omElement);
        }
        this.filledTable = true;
    }

    public static String getAttvalue(OMAttribute omatribute) {
        String ref = omatribute.getAttributeValue();
        if (ref != null && ref.charAt(0) == '#') {
            ref = ref.substring(1);
        }
        return ref;
    }

    public static OMAttribute processRefAtt(OMElement omElement) {
        OMAttribute omatribute = omElement.getAttribute(new QName(SOAP11_REF_ATTR));
        if (omatribute == null) {
            omatribute = omElement.getAttribute(new QName(SOAP12_REF_ATTR));
        }
        return omatribute;
    }

    public void clean() {
        this.elementMap.clear();
        this.objectmap.clear();
    }

    public static void processHrefAttributes(SOAPEnvelope soapEnvelope) throws AxisFault {
        SOAPBody soapBody = soapEnvelope.getBody();
        soapBody.build();
        OMElement omElement = null;
        OMAttribute idAttribute = null;
        HashMap<String, OMElement> idAndOMElementMap = new HashMap<String, OMElement>();
        Iterator iter = soapBody.getChildElements();
        while (iter.hasNext()) {
            omElement = (OMElement)iter.next();
            idAttribute = omElement.getAttribute(new QName(null, "id"));
            if (idAttribute == null) continue;
            idAndOMElementMap.put(idAttribute.getAttributeValue(), omElement);
        }
        MultirefHelper.processHrefAttributes(idAndOMElementMap, soapBody.getFirstElement(), OMAbstractFactory.getOMFactory());
    }

    public static void processHrefAttributes(Map idAndOMElementMap, OMElement elementToProcess, OMFactory omFactory) throws AxisFault {
        OMAttribute hrefAttribute = elementToProcess.getAttribute(new QName(null, SOAP11_REF_ATTR));
        if (hrefAttribute != null) {
            String hrefAttributeValue = hrefAttribute.getAttributeValue();
            if (!hrefAttributeValue.startsWith("#")) {
                throw new AxisFault("In valid href ==> " + hrefAttributeValue + " does not starts with #");
            }
            OMElement referedOMElement = (OMElement)idAndOMElementMap.get(hrefAttributeValue.substring(1));
            if (referedOMElement == null) {
                throw new AxisFault("In valid href ==> " + hrefAttributeValue + " can not findthe matching element");
            }
            elementToProcess.removeAttribute(hrefAttribute);
            OMElement clonedReferenceElement = MultirefHelper.getClonedOMElement(referedOMElement, omFactory);
            OMNode omNode = null;
            Iterator iter = clonedReferenceElement.getChildren();
            while (iter.hasNext()) {
                omNode = (OMNode)iter.next();
                iter.remove();
                elementToProcess.addChild(omNode);
            }
            OMAttribute omAttribute = null;
            Iterator iter2 = clonedReferenceElement.getAllAttributes();
            while (iter2.hasNext()) {
                omAttribute = (OMAttribute)iter2.next();
                if (omAttribute.getLocalName().equals("id")) continue;
                elementToProcess.addAttribute(omAttribute);
            }
        }
        OMElement childOMElement = null;
        Iterator iter = elementToProcess.getChildElements();
        while (iter.hasNext()) {
            childOMElement = (OMElement)iter.next();
            MultirefHelper.processHrefAttributes(idAndOMElementMap, childOMElement, omFactory);
        }
    }

    public static OMElement getClonedOMElement(OMElement omElement, OMFactory omFactory) throws AxisFault {
        OMElement newOMElement = omFactory.createOMElement(omElement.getQName());
        OMAttribute omAttribute = null;
        OMAttribute newOMAttribute = null;
        Iterator iter = omElement.getAllAttributes();
        while (iter.hasNext()) {
            omAttribute = (OMAttribute)iter.next();
            if (omAttribute.getAttributeValue().equals("id")) continue;
            newOMAttribute = omFactory.createOMAttribute(omAttribute.getLocalName(), omAttribute.getNamespace(), omAttribute.getAttributeValue());
            newOMElement.addAttribute(newOMAttribute);
        }
        OMNode omNode = null;
        OMText omText = null;
        Iterator iter2 = omElement.getChildren();
        while (iter2.hasNext()) {
            omNode = (OMNode)iter2.next();
            if (omNode instanceof OMText) {
                omText = (OMText)omNode;
                newOMElement.addChild((OMNode)omFactory.createOMText(omText.getText()));
                continue;
            }
            if (omNode instanceof OMElement) {
                newOMElement.addChild((OMNode)MultirefHelper.getClonedOMElement((OMElement)omNode, omFactory));
                continue;
            }
            throw new AxisFault("Unknown child element type ==> " + omNode.getClass().getName());
        }
        return newOMElement;
    }
}

