/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Wss10;

public class Wss11
extends Wss10 {
    private boolean MustSupportRefThumbprint;
    private boolean MustSupportRefEncryptedKey;
    private boolean RequireSignatureConfirmation;

    public Wss11(int version) {
        super(version);
    }

    public boolean isMustSupportRefEncryptedKey() {
        return this.MustSupportRefEncryptedKey;
    }

    public void setMustSupportRefEncryptedKey(boolean mustSupportRefEncryptedKey) {
        this.MustSupportRefEncryptedKey = mustSupportRefEncryptedKey;
    }

    public boolean isMustSupportRefThumbprint() {
        return this.MustSupportRefThumbprint;
    }

    public void setMustSupportRefThumbprint(boolean mustSupportRefThumbprint) {
        this.MustSupportRefThumbprint = mustSupportRefThumbprint;
    }

    public boolean isRequireSignatureConfirmation() {
        return this.RequireSignatureConfirmation;
    }

    public void setRequireSignatureConfirmation(boolean requireSignatureConfirmation) {
        this.RequireSignatureConfirmation = requireSignatureConfirmation;
    }

    @Override
    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.WSS11;
        }
        return SP11Constants.WSS11;
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        Wss11.writeStartElement(writer, prefix, localname, namespaceURI);
        Wss11.writeStartElement(writer, SPConstants.POLICY);
        if (this.isMustSupportRefKeyIdentifier()) {
            Wss11.writeEmptyElement(writer, prefix, "MustSupportRefKeyIdentifier", namespaceURI);
        }
        if (this.isMustSupportRefIssuerSerial()) {
            Wss11.writeEmptyElement(writer, prefix, "MustSupportRefIssuerSerial", namespaceURI);
        }
        if (this.isMustSupportRefExternalURI()) {
            Wss11.writeEmptyElement(writer, prefix, "MustSupportRefExternalURI", namespaceURI);
        }
        if (this.isMustSupportRefEmbeddedToken()) {
            Wss11.writeEmptyElement(writer, prefix, "MustSupportRefEmbeddedToken", namespaceURI);
        }
        if (this.isMustSupportRefThumbprint()) {
            Wss11.writeEmptyElement(writer, prefix, "MustSupportRefThumbprint", namespaceURI);
        }
        if (this.isMustSupportRefEncryptedKey()) {
            Wss11.writeEmptyElement(writer, prefix, "MustSupportRefEncryptedkey", namespaceURI);
        }
        if (this.isRequireSignatureConfirmation()) {
            Wss11.writeEmptyElement(writer, prefix, "RequireSignatureConfirmation", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

