/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.model.IssuedToken;

public class IssuedTokenBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        OMElement policyElement;
        OMElement rstTmplElem;
        OMElement issuerElem;
        IssuedToken issuedToken = new IssuedToken(1);
        OMAttribute includeAttr = element.getAttribute(SP11Constants.INCLUDE_TOKEN);
        if (includeAttr != null) {
            issuedToken.setInclusion(SP11Constants.getInclusionFromAttributeValue(includeAttr.getAttributeValue()));
        }
        if ((issuerElem = element.getFirstChildWithName(SP11Constants.ISSUER)) != null) {
            OMElement issuerEpr = issuerElem.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "Address"));
            if (issuerEpr == null) {
                issuerEpr = issuerElem.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address"));
            }
            issuedToken.setIssuerEpr(issuerEpr);
        }
        if (issuerElem != null) {
            OMElement issuerMex = issuerElem.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "Metadata"));
            if (issuerMex == null) {
                issuerMex = issuerElem.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Metadata"));
            }
            issuedToken.setIssuerMex(issuerMex);
        }
        if ((rstTmplElem = element.getFirstChildWithName(SP11Constants.REQUEST_SECURITY_TOKEN_TEMPLATE)) != null) {
            issuedToken.setRstTemplate(rstTmplElem);
        }
        if ((policyElement = element.getFirstChildWithName(Constants.Q_ELEM_POLICY)) != null) {
            Policy policy = PolicyEngine.getPolicy((OMElement)policyElement);
            Iterator iterator = (policy = policy.normalize(false)).getAlternatives();
            if (iterator.hasNext()) {
                this.processAlternative((List)iterator.next(), issuedToken);
            }
        }
        return issuedToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.ISSUED_TOKEN};
    }

    private void processAlternative(List<Assertion> assertions, IssuedToken parent) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (SP11Constants.REQUIRE_DERIVED_KEYS.equals(name)) {
                parent.setDerivedKeys(true);
                continue;
            }
            if (SP11Constants.REQUIRE_EXTERNAL_REFERNCE.equals(name)) {
                parent.setRequireExternalReference(true);
                continue;
            }
            if (!SP11Constants.REQUIRE_INTERNAL_REFERNCE.equals(name)) continue;
            parent.setRequireInternalReference(true);
        }
    }
}

