/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.LastMessageNumber;

public class TerminateSequence
implements IOMRMPart {
    private Identifier identifier;
    private LastMessageNumber lastMessageNumber;
    private String namespaceValue = null;

    public TerminateSequence(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement body) throws OMException, SandeshaException {
        OMElement lastMessageNumberPart;
        if (!(body instanceof SOAPBody)) {
            throw new OMException(SandeshaMessageHelper.getMessage("terminateSeqCannotBeAddedToNonBody"));
        }
        OMElement terminateSeqPart = body.getFirstChildWithName(new QName(this.namespaceValue, "TerminateSequence"));
        if (terminateSeqPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noTerminateSeqInElement", body.toString()));
        }
        this.identifier = new Identifier(this.namespaceValue);
        OMElement identifierPart = terminateSeqPart.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
        if (identifierPart != null) {
            this.identifier.fromOMElement(identifierPart);
        }
        if ((lastMessageNumberPart = terminateSeqPart.getFirstChildWithName(new QName(this.namespaceValue, "LastMsgNumber"))) != null) {
            this.lastMessageNumber = new LastMessageNumber(this.namespaceValue);
            this.lastMessageNumber.fromOMElement(lastMessageNumberPart);
        }
        return this;
    }

    public OMElement toOMElement(OMElement body) throws OMException {
        if (body == null || !(body instanceof SOAPBody)) {
            throw new OMException(SandeshaMessageHelper.getMessage("terminateSeqCannotBeAddedToNonBody"));
        }
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullMsgId"));
        }
        OMFactory factory = body.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement terminateSequenceElement = factory.createOMElement("TerminateSequence", rmNamespace);
        this.identifier.toOMElement(terminateSequenceElement, rmNamespace);
        if (this.lastMessageNumber != null) {
            this.lastMessageNumber.toOMElement(terminateSequenceElement, rmNamespace);
        }
        body.addChild((OMNode)terminateSequenceElement);
        return body;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setLastMessageNumber(LastMessageNumber number) {
        this.lastMessageNumber = number;
    }

    public LastMessageNumber getLastMessageNumber() {
        return this.lastMessageNumber;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPBody body = envelope.getBody();
        OMElement elem = body.getFirstChildWithName(new QName(this.namespaceValue, "TerminateSequence"));
        if (elem != null) {
            elem.detach();
        }
        this.toOMElement((OMElement)body);
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }

    public static boolean isLastMsgNumberRequired(String namespaceName) {
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

