/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.jdbc.JDBCTransaction;
import org.apache.sandesha2.storage.jdbc.PersistentInvokerBeanMgr;
import org.apache.sandesha2.storage.jdbc.PersistentRMDBeanMgr;
import org.apache.sandesha2.storage.jdbc.PersistentRMSBeanMgr;
import org.apache.sandesha2.storage.jdbc.PersistentSenderBeanMgr;
import org.apache.sandesha2.storage.jdbc.TransactionLock;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.Invoker;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.Sender;

public class PersistentStorageManager
extends StorageManager {
    private Connection dbConnection = null;
    private String dbConnectionString = null;
    private String dbDriver = null;
    private String dbUser = null;
    private String dbPassword = null;
    private PersistentRMSBeanMgr pRMSBeanMgr = null;
    private PersistentRMDBeanMgr pRMDBeanMgr = null;
    private PersistentSenderBeanMgr pSenderBeanMgr = null;
    private PersistentInvokerBeanMgr pInvokerBeanMgr = null;
    private Sender sender = null;
    private Invoker invoker = null;
    private PollingManager pollingManager = null;
    private boolean useSerialization = false;
    private HashMap<String, MessageContext> storageMap = null;
    private static ThreadLocal<Transaction> threadTransaction = null;
    private static final Log log = LogFactory.getLog(PersistentStorageManager.class);
    private TransactionLock transactionLock;

    public SandeshaThread getInvoker() {
        return this.invoker;
    }

    public PollingManager getPollingManager() {
        return this.pollingManager;
    }

    public SandeshaThread getSender() {
        return this.sender;
    }

    public PersistentStorageManager(ConfigurationContext context) throws SandeshaException {
        super(context);
        ModuleConfiguration mc;
        log.info((Object)"create PersistentStorageManager");
        this.storageMap = new HashMap();
        threadTransaction = new ThreadLocal();
        this.pRMSBeanMgr = new PersistentRMSBeanMgr(this);
        this.pRMDBeanMgr = new PersistentRMDBeanMgr(this);
        this.pSenderBeanMgr = new PersistentSenderBeanMgr(this);
        this.pInvokerBeanMgr = new PersistentInvokerBeanMgr(this);
        this.sender = new Sender();
        SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean((AxisDescription)context.getAxisConfiguration());
        this.useSerialization = policy.isUseMessageSerialization();
        if (policy.isInOrder()) {
            this.invoker = new Invoker();
        }
        if (policy.isEnableMakeConnection()) {
            this.pollingManager = new PollingManager();
        }
        if ((mc = context.getAxisConfiguration().getModuleConfig("sandesha2")) != null) {
            Parameter param = mc.getParameter("db.connectionstring");
            if (param != null) {
                this.dbConnectionString = (String)param.getValue();
                log.debug((Object)(param.getName() + "=" + this.dbConnectionString));
            }
            if ((param = mc.getParameter("db.driver")) != null) {
                this.dbDriver = (String)param.getValue();
                log.debug((Object)(param.getName() + "=" + this.dbDriver));
            }
            if ((param = mc.getParameter("db.user")) != null) {
                this.dbUser = (String)param.getValue();
                log.debug((Object)(param.getName() + "=" + this.dbUser));
            }
            if ((param = mc.getParameter("db.password")) != null) {
                this.dbPassword = (String)param.getValue();
                log.debug((Object)(param.getName() + "=" + this.dbPassword));
            }
        }
        this.transactionLock = new TransactionLock();
    }

    public void shutdown() {
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
                this.dbConnection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.shutdown();
    }

    public InvokerBeanMgr getInvokerBeanMgr() {
        return this.pInvokerBeanMgr;
    }

    public RMDBeanMgr getRMDBeanMgr() {
        return this.pRMDBeanMgr;
    }

    public RMSBeanMgr getRMSBeanMgr() {
        return this.pRMSBeanMgr;
    }

    public SenderBeanMgr getSenderBeanMgr() {
        return this.pSenderBeanMgr;
    }

    public boolean requiresMessageSerialization() {
        return this.useSerialization;
    }

    public boolean hasUserTransaction(MessageContext msg) {
        return false;
    }

    public Transaction getTransaction() {
        Transaction transaction = threadTransaction.get();
        if (transaction == null) {
            this.acquireTransactionLock();
            transaction = new JDBCTransaction(this);
            threadTransaction.set(transaction);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Possible re-used transaction: ");
            }
            transaction = null;
        }
        return transaction;
    }

    public void removeTransaction() {
        threadTransaction.set(null);
    }

    public Connection getDbConnection() {
        JDBCTransaction transaction = (JDBCTransaction)threadTransaction.get();
        if (transaction == null) {
            return this.dbConnection;
        }
        return transaction.getDbConnection();
    }

    public void initStorage(AxisModule moduleDesc) throws SandeshaStorageException {
        log.info((Object)"init PersistentStorageManager");
        if (this.dbConnectionString == null && moduleDesc.getParameter("db.connectionstring") != null) {
            this.dbConnectionString = (String)moduleDesc.getParameter("db.connectionstring").getValue();
        }
        if (this.dbDriver == null && moduleDesc.getParameter("db.driver") != null) {
            this.dbDriver = (String)moduleDesc.getParameter("db.driver").getValue();
        }
        if (this.dbUser == null && moduleDesc.getParameter("db.user") != null) {
            this.dbUser = (String)moduleDesc.getParameter("db.user").getValue();
        }
        if (this.dbPassword == null && moduleDesc.getParameter("db.password") != null) {
            this.dbPassword = (String)moduleDesc.getParameter("db.password").getValue();
        }
        if (this.dbConnectionString == null || this.dbDriver == null) {
            throw new SandeshaStorageException("Can't proceed. Needed properties are not set.");
        }
        this.dbConnection = this.dbConnect();
    }

    public Connection dbConnect() throws SandeshaStorageException {
        try {
            Class.forName(this.dbDriver);
            return DriverManager.getConnection(this.dbConnectionString, this.dbUser, this.dbPassword);
        }
        catch (Exception ex) {
            log.error((Object)"Unable to create DB connection ", (Throwable)ex);
            throw new SandeshaStorageException(ex);
        }
    }

    public MessageContext retrieveMessageContext(String key, ConfigurationContext configContext) throws SandeshaStorageException {
        log.debug((Object)("Enter retrieveMessageContext for key " + key));
        if (this.storageMap.containsKey(key)) {
            log.debug((Object)"retrieveMessageContext get from cache");
            return this.storageMap.get(key);
        }
        try {
            Statement stmt = this.getDbConnection().createStatement();
            ResultSet rs = stmt.executeQuery("select * from wsrm_msgctx where ctx_key='" + key + "'");
            rs.next();
            MessageContext msgCtx = new MessageContext();
            msgCtx.readExternal((ObjectInput)new ObjectInputStream(rs.getBinaryStream("ctx")));
            msgCtx.activate(configContext);
            msgCtx.setProperty("PostFailureMessage", (Object)"true");
            rs.close();
            stmt.close();
            log.debug((Object)"RetrieveMessageContext get from DB");
            return msgCtx;
        }
        catch (Exception ex) {
            log.error((Object)("RetrieveMessageContext exception " + ex));
            throw new SandeshaStorageException(ex);
        }
    }

    public synchronized void storeMessageContext(String key, MessageContext msgContext) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter storeMessageContext for key " + key + " context " + msgContext));
        }
        this.storageMap.put(key, msgContext);
        try {
            PreparedStatement pstmt = this.getDbConnection().prepareStatement("insert into wsrm_msgctx(ctx_key,ctx)values(?,?)");
            pstmt.setString(1, key);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            msgContext.writeExternal((ObjectOutput)oos);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            pstmt.setBinaryStream(2, (InputStream)bais, bais.available());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
    }

    public synchronized void updateMessageContext(String key, MessageContext msgContext) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateMessageContext key : " + key));
        }
        this.storageMap.put(key, msgContext);
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getDbConnection().prepareStatement("update wsrm_msgctx set ctx=?where ctx_key='" + key + "'");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            msgContext.writeExternal((ObjectOutput)oos);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            pstmt.setBinaryStream(1, (InputStream)bais, bais.available());
            pstmt.executeQuery();
            pstmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException("Exception in updateMessageContext", ex);
        }
    }

    public void removeMessageContext(String key) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeMessageContext key : " + key));
        }
        try {
            Statement stmt = this.getDbConnection().createStatement();
            MessageContext messageInCache = this.storageMap.get(key);
            if (messageInCache != null) {
                this.storageMap.remove(key);
            }
            stmt.executeUpdate("delete from wsrm_msgctx where ctx_key='" + key + "'");
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException("Exception in removeMessageContext", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireTransactionLock() {
        TransactionLock transactionLock = this.transactionLock;
        synchronized (transactionLock) {
            if (this.transactionLock.isAcquried()) {
                try {
                    this.transactionLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.acquireTransactionLock();
            } else {
                this.transactionLock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTransactionLock() {
        TransactionLock transactionLock = this.transactionLock;
        synchronized (transactionLock) {
            this.transactionLock.release();
        }
    }
}

