/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import org.jclouds.cloudstack.domain.GuestIPType;
import org.jclouds.cloudstack.domain.TrafficType;
import org.jclouds.javax.annotation.Nullable;

public class NIC {
    private final String id;
    private final URI broadcastURI;
    private final String gateway;
    private final String IPAddress;
    private final boolean isDefault;
    private final URI isolationURI;
    private final String netmask;
    private final String macAddress;
    private final String networkId;
    private final TrafficType trafficType;
    private final GuestIPType guestIPType;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromNIC(this);
    }

    @ConstructorProperties(value={"id", "broadcasturi", "gateway", "ipaddress", "isdefault", "isolationuri", "netmask", "macaddress", "networkid", "traffictype", "type"})
    protected NIC(String id, @Nullable URI broadcastURI, @Nullable String gateway, @Nullable String IPAddress, boolean isDefault, @Nullable URI isolationURI, @Nullable String netmask, @Nullable String macAddress, @Nullable String networkId, @Nullable TrafficType trafficType, @Nullable GuestIPType guestIPType) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.broadcastURI = broadcastURI;
        this.gateway = gateway;
        this.IPAddress = IPAddress;
        this.isDefault = isDefault;
        this.isolationURI = isolationURI;
        this.netmask = netmask;
        this.macAddress = macAddress;
        this.networkId = networkId;
        this.trafficType = trafficType;
        this.guestIPType = guestIPType;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public URI getBroadcastURI() {
        return this.broadcastURI;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    @Nullable
    public String getIPAddress() {
        return this.IPAddress;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Nullable
    public URI getIsolationURI() {
        return this.isolationURI;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getMacAddress() {
        return this.macAddress;
    }

    @Nullable
    public String getNetworkId() {
        return this.networkId;
    }

    @Nullable
    public TrafficType getTrafficType() {
        return this.trafficType;
    }

    @Nullable
    public GuestIPType getGuestIPType() {
        return this.guestIPType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.broadcastURI, this.gateway, this.IPAddress, this.isDefault, this.isolationURI, this.netmask, this.macAddress, this.networkId, this.trafficType, this.guestIPType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NIC that = (NIC)NIC.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.broadcastURI, (Object)that.broadcastURI) && Objects.equal((Object)this.gateway, (Object)that.gateway) && Objects.equal((Object)this.IPAddress, (Object)that.IPAddress) && Objects.equal((Object)this.isDefault, (Object)that.isDefault) && Objects.equal((Object)this.isolationURI, (Object)that.isolationURI) && Objects.equal((Object)this.netmask, (Object)that.netmask) && Objects.equal((Object)this.macAddress, (Object)that.macAddress) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)((Object)this.trafficType), (Object)((Object)that.trafficType)) && Objects.equal((Object)((Object)this.guestIPType), (Object)((Object)that.guestIPType));
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("broadcastURI", (Object)this.broadcastURI).add("gateway", (Object)this.gateway).add("IPAddress", (Object)this.IPAddress).add("isDefault", this.isDefault).add("isolationURI", (Object)this.isolationURI).add("netmask", (Object)this.netmask).add("macAddress", (Object)this.macAddress).add("networkId", (Object)this.networkId).add("trafficType", (Object)this.trafficType).add("guestIPType", (Object)this.guestIPType);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected URI broadcastURI;
        protected String gateway;
        protected String IPAddress;
        protected boolean isDefault;
        protected URI isolationURI;
        protected String netmask;
        protected String macAddress;
        protected String networkId;
        protected TrafficType trafficType;
        protected GuestIPType guestIPType;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T broadcastURI(URI broadcastURI) {
            this.broadcastURI = broadcastURI;
            return this.self();
        }

        public T gateway(String gateway) {
            this.gateway = gateway;
            return this.self();
        }

        public T IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this.self();
        }

        public T isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this.self();
        }

        public T isolationURI(URI isolationURI) {
            this.isolationURI = isolationURI;
            return this.self();
        }

        public T netmask(String netmask) {
            this.netmask = netmask;
            return this.self();
        }

        public T macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this.self();
        }

        public T networkId(String networkId) {
            this.networkId = networkId;
            return this.self();
        }

        public T trafficType(TrafficType trafficType) {
            this.trafficType = trafficType;
            return this.self();
        }

        public T guestIPType(GuestIPType guestIPType) {
            this.guestIPType = guestIPType;
            return this.self();
        }

        public NIC build() {
            return new NIC(this.id, this.broadcastURI, this.gateway, this.IPAddress, this.isDefault, this.isolationURI, this.netmask, this.macAddress, this.networkId, this.trafficType, this.guestIPType);
        }

        public T fromNIC(NIC in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).broadcastURI(in.getBroadcastURI())).gateway(in.getGateway())).IPAddress(in.getIPAddress())).isDefault(in.isDefault())).isolationURI(in.getIsolationURI())).netmask(in.getNetmask())).macAddress(in.getMacAddress())).networkId(in.getNetworkId())).trafficType(in.getTrafficType())).guestIPType(in.getGuestIPType());
        }
    }
}

