/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.Serializable;
import java.util.Date;
import org.bson.BsonType;
import org.bson.BsonValue;

public final class BsonTimestamp
extends BsonValue
implements Comparable<BsonTimestamp>,
Serializable {
    private static final long serialVersionUID = 2318841189917887752L;
    private final int inc;
    private final Date time;

    public BsonTimestamp() {
        this.inc = 0;
        this.time = null;
    }

    public BsonTimestamp(int time, int inc) {
        this.time = new Date((long)time * 1000L);
        this.inc = inc;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.TIMESTAMP;
    }

    public int getTime() {
        if (this.time == null) {
            return 0;
        }
        return (int)(this.time.getTime() / 1000L);
    }

    public int getInc() {
        return this.inc;
    }

    public String toString() {
        return "Timestamp{inc=" + this.inc + ", time=" + this.time + '}';
    }

    @Override
    public int compareTo(BsonTimestamp ts) {
        if (this.getTime() != ts.getTime()) {
            return this.getTime() - ts.getTime();
        }
        return this.getInc() - ts.getInc();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonTimestamp timestamp = (BsonTimestamp)o;
        if (this.inc != timestamp.inc) {
            return false;
        }
        return this.time.equals(timestamp.time);
    }

    public int hashCode() {
        int result = this.inc;
        result = 31 * result + this.time.hashCode();
        return result;
    }
}

