/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.catalog.functions.ServiceEndpointResolutionStrategy;
import org.jclouds.openstack.keystone.catalog.functions.ServiceEndpointToRegion;

public class LocationIdToURIFromServiceEndpointsForTypeAndVersion
implements Supplier<Map<String, Supplier<URI>>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Supplier<List<ServiceEndpoint>> serviceEndpoints;
    protected final ServiceEndpointResolutionStrategy resolveServiceEndpointURI;
    protected final ServiceEndpointToRegion serviceEndpointToRegion;
    protected final String apiType;
    protected final String apiVersion;
    private final Predicate<ServiceEndpoint> apiVersionEqualsVersionId = new Predicate<ServiceEndpoint>(){

        public boolean apply(ServiceEndpoint input) {
            return input.version().equals(LocationIdToURIFromServiceEndpointsForTypeAndVersion.this.apiVersion);
        }
    };
    private final Predicate<ServiceEndpoint> versionAware = new Predicate<ServiceEndpoint>(){

        public boolean apply(ServiceEndpoint input) {
            return input.version() != null;
        }
    };
    private final Predicate<ServiceEndpoint> apiTypeEquals = new Predicate<ServiceEndpoint>(){

        public boolean apply(ServiceEndpoint input) {
            return input.type().equals(LocationIdToURIFromServiceEndpointsForTypeAndVersion.this.apiType);
        }
    };

    @Inject
    LocationIdToURIFromServiceEndpointsForTypeAndVersion(Supplier<List<ServiceEndpoint>> serviceEndpoints, ServiceEndpointResolutionStrategy resolveServiceEndpointURI, ServiceEndpointToRegion serviceEndpointToRegion, @Assisted(value="apiType") String apiType, @Nullable @Assisted(value="apiVersion") String apiVersion) {
        this.serviceEndpoints = serviceEndpoints;
        this.resolveServiceEndpointURI = resolveServiceEndpointURI;
        this.serviceEndpointToRegion = serviceEndpointToRegion;
        this.apiType = apiType;
        this.apiVersion = apiVersion;
    }

    public Map<String, Supplier<URI>> get() {
        List endpoints = (List)this.serviceEndpoints.get();
        if (endpoints.isEmpty()) {
            throw new NoSuchElementException("No endpoints were found in the service catalog. Make sure your authentication token has the right scopes and permissions");
        }
        Iterable endpointsForType = Iterables.filter((Iterable)endpoints, this.apiTypeEquals);
        if (Iterables.isEmpty((Iterable)endpointsForType)) {
            throw new NoSuchElementException(String.format("no endpoints for apiType %s in service endpoints %s", this.apiType, endpoints));
        }
        boolean checkVersionId = this.apiVersion != null && Iterables.any((Iterable)endpointsForType, this.versionAware);
        Predicate<ServiceEndpoint> versionFilter = checkVersionId ? this.apiVersionEqualsVersionId : Predicates.alwaysTrue();
        Iterable endpointsForTypeAndVersion = Iterables.filter((Iterable)endpointsForType, versionFilter);
        if (Iterables.isEmpty((Iterable)endpointsForTypeAndVersion)) {
            throw new NoSuchElementException(String.format("no service endpoints for apiType %s are of version %s, or version agnostic: %s", this.apiType, this.apiVersion, endpointsForType));
        }
        this.logger.debug("service endpoints for apiType %s and version %s: %s", new Object[]{this.apiType, this.apiVersion, endpointsForTypeAndVersion});
        ImmutableListMultimap locationToServiceEndpoints = Multimaps.index((Iterable)endpointsForTypeAndVersion, (Function)this.serviceEndpointToRegion);
        return Maps.transformValues((Map)Multimaps.asMap((Multimap)locationToServiceEndpoints), (Function)this.resolveServiceEndpointURI);
    }

    public String toString() {
        return "locationIdToURIFromServiceEndpointsForTypeAndVersion(" + this.apiType + ", " + this.apiVersion + ")";
    }

    public static interface Factory {
        public LocationIdToURIFromServiceEndpointsForTypeAndVersion createForApiTypeAndVersion(@Assisted(value="apiType") String var1, @Nullable @Assisted(value="apiVersion") String var2) throws NoSuchElementException;
    }
}

