/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.MethodCoercions;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.jclouds.compute.options.TemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateOptionsOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateOptionsOption.class);

    @Override
    public void apply(TemplateOptions options, ConfigBag config, Object v) {
        if (v == null) {
            return;
        }
        Map optionsMap = (Map)v;
        if (optionsMap.isEmpty()) {
            return;
        }
        Class<?> clazz = options.getClass();
        for (Map.Entry option : optionsMap.entrySet()) {
            Object optionValue = option.getValue();
            if (optionValue != null) {
                Maybe result;
                try {
                    ExecutionContext exec = BrooklynTaskTags.getCurrentExecutionContext();
                    if (exec != null) {
                        optionValue = Tasks.resolveDeepValue(optionValue, Object.class, (ExecutionContext)exec);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    Exceptions.propagate((Throwable)e);
                }
                if (!(result = MethodCoercions.tryFindAndInvokeBestMatchingMethod((Object)options, (String)((String)option.getKey()), optionValue)).isAbsent()) continue;
                LOG.warn("Ignoring request to set template option {} because this is not supported by {}", new Object[]{option.getKey(), clazz.getCanonicalName()});
                continue;
            }
            LOG.debug("Ignoring request to set template option {} because value is null", new Object[]{option.getKey(), clazz.getCanonicalName()});
        }
    }
}

