/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Optional;
import java.util.Date;
import java.util.Map;
import org.jclouds.azureblob.options.CopyBlobOptions;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindAzureCopyOptionsToRequest
implements Binder {
    private static final DateService dateService = new SimpleDateFormatDateService();

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Optional<String> ifNoneMatch;
        Optional<String> ifMatch;
        Optional<Date> ifUnmodifiedSince;
        Optional<Date> ifModifiedSince;
        HttpRequest.Builder builder = request.toBuilder();
        CopyBlobOptions options = (CopyBlobOptions)input;
        Optional<Map<String, String>> userMetadata = options.getUserMetadata();
        if (userMetadata.isPresent()) {
            for (Map.Entry entry : ((Map)userMetadata.get()).entrySet()) {
                builder.addHeader("x-ms-meta-" + (String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
        }
        if ((ifModifiedSince = options.getIfModifiedSince()).isPresent()) {
            builder.addHeader("x-ms-source-if-modified-since", new String[]{dateService.rfc822DateFormat((Date)ifModifiedSince.get())});
        }
        if ((ifUnmodifiedSince = options.getIfUnmodifiedSince()).isPresent()) {
            builder.addHeader("x-ms-source-if-unmodified-since", new String[]{dateService.rfc822DateFormat((Date)ifUnmodifiedSince.get())});
        }
        if ((ifMatch = options.getIfMatch()).isPresent()) {
            builder.addHeader("x-ms-source-if-match", new String[]{(String)ifMatch.get()});
        }
        if ((ifNoneMatch = options.getIfNoneMatch()).isPresent()) {
            builder.addHeader("x-ms-source-if-none-match", new String[]{(String)ifNoneMatch.get()});
        }
        return (R)builder.build();
    }
}

