/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Subnetwork;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.options.SubnetworkCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/subnetworks")
@Consumes(value={"application/json"})
public interface SubnetworkApi {
    @Named(value="Subnetworks:get")
    @GET
    @Path(value="/{subnetwork}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Subnetwork get(@PathParam(value="subnetwork") String var1);

    @Named(value="Subnetworks:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation createInNetwork(@BinderParam(value=BindToJsonPayload.class) SubnetworkCreationOptions var1);

    @Named(value="Subnetworks:delete")
    @DELETE
    @Path(value="/{subnetwork}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="subnetwork") String var1);

    @Named(value="Subnetworks:list")
    @GET
    public ListPage<Subnetwork> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Subnetworks:list")
    @GET
    @Transform(value=SubnetworkPages.class)
    public Iterator<ListPage<Subnetwork>> list();

    @Named(value="Subnetworks:list")
    @GET
    @Transform(value=SubnetworkPages.class)
    public Iterator<ListPage<Subnetwork>> list(ListOptions var1);

    public static final class SubnetworkPages
    extends BaseCallerArg0ToIteratorOfListPage<Subnetwork, SubnetworkPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        SubnetworkPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Subnetwork>> fetchNextPage(final String region, final ListOptions options) {
            return new Function<String, ListPage<Subnetwork>>(){

                public ListPage<Subnetwork> apply(String pageToken) {
                    return SubnetworkPages.this.api.subnetworksInRegion(region).listPage(pageToken, options);
                }
            };
        }
    }
}

