/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.AbstractAddSensorFeed;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshValueFunctions;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SshCommandSensor<T>
extends AbstractAddSensorFeed<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommandSensor.class);
    public static final ConfigKey<String> SENSOR_COMMAND = ConfigKeys.newStringConfigKey("command", "SSH command to execute for sensor");
    public static final ConfigKey<String> SENSOR_EXECUTION_DIR = ConfigKeys.newStringConfigKey("executionDir", "Directory where the command should run; if not supplied, executes in the entity's run dir (or home dir if no run dir is defined); use '~' to always execute in the home dir, or 'custom-feed/' to execute in a custom-feed dir relative to the run dir");
    public static final ConfigKey<Object> VALUE_ON_ERROR = ConfigKeys.newConfigKey(Object.class, "value.on.error", "Value to be used if an error occurs whilst executing the ssh command", null);
    public static final MapConfigKey<Object> SENSOR_SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    private String command;
    private String executionDir;
    private Map<String, Object> sensorEnv;

    public SshCommandSensor(ConfigBag params) {
        super(params);
    }

    @Override
    public void apply(final EntityLocal entity) {
        super.apply(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding SSH sensor {} to {}", (Object)this.name, (Object)entity);
        }
        Boolean suppressDuplicates = (Boolean)EntityInitializers.resolve(this.params, SUPPRESS_DUPLICATES);
        Duration logWarningGraceTimeOnStartup = (Duration)EntityInitializers.resolve(this.params, LOG_WARNING_GRACE_TIME_ON_STARTUP);
        Duration logWarningGraceTime = (Duration)EntityInitializers.resolve(this.params, LOG_WARNING_GRACE_TIME);
        EnvSupplier envSupplier = new EnvSupplier((Entity)entity, this.params);
        CommandSupplier commandSupplier = new CommandSupplier((Entity)entity, this.params);
        CommandPollConfig pollConfig = (CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)new CommandPollConfig(this.sensor).period(this.period)).env(envSupplier).command(commandSupplier).suppressDuplicates(Boolean.TRUE.equals(suppressDuplicates))).checkSuccess(SshValueFunctions.exitStatusEquals(0))).onFailureOrException(Functions.constant((Object)this.params.get(VALUE_ON_ERROR)))).onSuccess(Functionals.chain(SshValueFunctions.stdout(), (Function)StringFunctions.trimEnd(), TypeCoercions.function(this.sensor.getType())))).logWarningGraceTimeOnStartup(logWarningGraceTimeOnStartup)).logWarningGraceTime(logWarningGraceTime);
        SshFeed feed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)entity)).onlyIfServiceUp()).poll(pollConfig).build();
        entity.addFeed((Feed)feed);
        new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                if (entity == null) {
                    return ImmutableMap.of();
                }
                Object env = MutableMap.copyOf((Map)((Map)entity.getConfig(BrooklynConfigKeys.SHELL_ENVIRONMENT)));
                Map sensorEnv = (Map)SshCommandSensor.this.params.get(SENSOR_SHELL_ENVIRONMENT);
                if (sensorEnv != null) {
                    env.putAll(sensorEnv);
                }
                try {
                    env = (Map)Tasks.resolveDeepValue(env, Object.class, ((EntityInternal)entity).getExecutionContext());
                }
                catch (InterruptedException | ExecutionException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
                ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(((EntityInternal)entity).getManagementContext());
                return serializer.serialize((Map<?, ?>)env);
            }
        };
        new Supplier<String>(){

            public String get() {
                String command = (String)Preconditions.checkNotNull((Object)EntityInitializers.resolve(SshCommandSensor.this.params, SENSOR_COMMAND));
                String dir = EntityInitializers.resolve(SshCommandSensor.this.params, SENSOR_EXECUTION_DIR);
                return SshCommandSensor.makeCommandExecutingInDirectory(command, dir, (Entity)entity);
            }
        };
        new Function<String, T>(){

            public T apply(String input) {
                return TypeCoercions.coerce((Object)Strings.trimEnd((String)input), SshCommandSensor.this.sensor.getType());
            }
        };
    }

    @Beta
    public static String makeCommandExecutingInDirectory(String command, String executionDir, Entity entity) {
        String finalCommand = command;
        String execDir = executionDir;
        if (Strings.isBlank((CharSequence)execDir)) {
            String string = execDir = entity != null ? (String)entity.getAttribute(BrooklynConfigKeys.RUN_DIR) : null;
            if (Strings.isBlank((CharSequence)execDir)) {
                execDir = "~";
            }
        } else if (!Os.isAbsolutish((String)execDir)) {
            String runDir;
            String string = runDir = entity != null ? (String)entity.getAttribute(BrooklynConfigKeys.RUN_DIR) : null;
            if (!Strings.isBlank((CharSequence)runDir)) {
                execDir = Os.mergePaths((String[])new String[]{runDir, execDir});
            }
        }
        if (!"~".equals(execDir)) {
            finalCommand = "mkdir -p '" + execDir + "' && cd '" + execDir + "' && " + finalCommand;
        }
        return finalCommand;
    }

    private static class CommandSupplier
    implements Supplier<String> {
        private final Entity entity;
        private final Object rawSensorCommand;
        private final Object rawSensorExecDir;

        CommandSupplier(Entity entity, ConfigBag params) {
            this.entity = entity;
            this.rawSensorCommand = params.getAllConfigRaw().get(SENSOR_COMMAND.getName());
            this.rawSensorExecDir = params.getAllConfigRaw().get(SENSOR_EXECUTION_DIR.getName());
        }

        public String get() {
            ConfigBag params = ConfigBag.newInstance();
            if (this.rawSensorCommand != null) {
                params.putStringKey(SENSOR_COMMAND.getName(), this.rawSensorCommand);
            }
            if (this.rawSensorExecDir != null) {
                params.putStringKey(SENSOR_EXECUTION_DIR.getName(), this.rawSensorExecDir);
            }
            String command = (String)Preconditions.checkNotNull((Object)EntityInitializers.resolve(params, SENSOR_COMMAND));
            String dir = EntityInitializers.resolve(params, SENSOR_EXECUTION_DIR);
            return SshCommandSensor.makeCommandExecutingInDirectory(command, dir, this.entity);
        }
    }

    private static class EnvSupplier
    implements Supplier<Map<String, String>> {
        private final Entity entity;
        private final Object rawSensorShellEnv;

        EnvSupplier(Entity entity, ConfigBag params) {
            this.entity = entity;
            this.rawSensorShellEnv = params.getAllConfigRaw().getOrDefault(SENSOR_SHELL_ENVIRONMENT.getName(), SENSOR_SHELL_ENVIRONMENT.getDefaultValue());
        }

        public Map<String, String> get() {
            if (this.entity == null) {
                return ImmutableMap.of();
            }
            Object env = MutableMap.copyOf((Map)((Map)this.entity.getConfig(BrooklynConfigKeys.SHELL_ENVIRONMENT)));
            if (this.rawSensorShellEnv != null) {
                env.putAll(TypeCoercions.coerce(this.rawSensorShellEnv, new TypeToken<Map<String, Object>>(){}));
            }
            try {
                env = (Map)Tasks.resolveDeepValue(env, Object.class, ((EntityInternal)this.entity).getExecutionContext());
            }
            catch (InterruptedException | ExecutionException e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
            ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(((EntityInternal)this.entity).getManagementContext());
            return serializer.serialize((Map<?, ?>)env);
        }
    }
}

