/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestEndpointReachable;
import org.apache.brooklyn.test.framework.TestFrameworkAssertions;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEndpointReachableImpl
extends TargetableTestComponentImpl
implements TestEndpointReachable {
    private static final Logger LOG = LoggerFactory.getLogger(TestEndpointReachableImpl.class);

    public void start(Collection<? extends Location> locations) {
        if (!this.getChildren().isEmpty()) {
            throw new RuntimeException(String.format("The entity [%s] cannot have child entities", this.getClass().getName()));
        }
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        final String endpoint = (String)this.getConfig(ENDPOINT);
        final Object endpointSensor = this.getConfig(ENDPOINT_SENSOR);
        Duration timeout = (Duration)this.getConfig(TIMEOUT);
        Duration backoffToPeriod = (Duration)this.getConfig(BACKOFF_TO_PERIOD);
        List<Map<String, Object>> assertions = TestFrameworkAssertions.getAssertions(this, (ConfigKey<Object>)ASSERTIONS);
        final Entity target = this.resolveTarget();
        if (endpoint == null && endpointSensor == null) {
            throw new RuntimeException(String.format("The entity [%s] must be configured with one of endpoint or endpointSensor", this.getClass().getName()));
        }
        if (endpoint != null && endpointSensor != null) {
            throw new RuntimeException(String.format("The entity [%s] must be configured with only one of endpoint or endpointSensor", this.getClass().getName()));
        }
        Supplier<HostAndPort> supplier = new Supplier<HostAndPort>(){

            public HostAndPort get() {
                Object val;
                if (endpoint != null) {
                    val = endpoint;
                } else if (endpointSensor instanceof AttributeSensor) {
                    val = target.sensors().get((AttributeSensor)endpointSensor);
                } else if (endpointSensor instanceof CharSequence) {
                    AttributeSensor sensor = Sensors.newSensor(Object.class, (String)((CharSequence)endpointSensor).toString());
                    val = target.sensors().get(sensor);
                } else {
                    throw new IllegalArgumentException(String.format("The entity [%s] has endpointSensor of invalid type %s [%s]", this.getClass().getName(), endpointSensor.getClass().getName(), endpointSensor));
                }
                return val == null ? null : TestEndpointReachableImpl.this.toHostAndPort(val);
            }
        };
        if (endpoint != null) {
            supplier.get();
        }
        try {
            ImmutableMap flags = ImmutableMap.of((Object)"timeout", (Object)timeout, (Object)"maxPeriod", (Object)backoffToPeriod);
            Asserts.succeedsEventually((Map)flags, (Runnable)new Runnable((Supplier)supplier, assertions){
                final /* synthetic */ Supplier val$supplier;
                final /* synthetic */ List val$assertions;
                {
                    this.val$supplier = supplier;
                    this.val$assertions = list;
                }

                @Override
                public void run() {
                    HostAndPort val = (HostAndPort)this.val$supplier.get();
                    Asserts.assertNotNull((Object)val);
                    TestEndpointReachableImpl.this.assertSucceeds(this.val$assertions, val);
                }
            });
            this.setUpAndRunState(true, Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            LOG.info("{} [{}] test failed", (Object)this, endpoint != null ? endpoint : endpointSensor);
            this.setUpAndRunState(false, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    protected void assertSucceeds(List<Map<String, Object>> assertions, HostAndPort endpoint) {
        Maybe<Object> checkReachableMaybe = this.getOnlyAssertionsValue(assertions, "reachable");
        boolean checkReachable = checkReachableMaybe.isAbsentOrNull() || Boolean.TRUE.equals(TypeCoercions.coerce((Object)checkReachableMaybe.get(), Boolean.class));
        boolean reachable = Networking.isReachable((HostAndPort)endpoint);
        Asserts.assertEquals((boolean)reachable, (boolean)checkReachable, (String)(endpoint + " " + (reachable ? "" : "not ") + "reachable"));
    }

    protected Maybe<Object> getOnlyAssertionsValue(List<Map<String, Object>> assertions, String key) {
        Maybe result = Maybe.absent();
        LinkedHashSet keys = Sets.newLinkedHashSet();
        boolean foundConflictingDuplicate = false;
        if (assertions != null) {
            for (Map<String, Object> assertionMap : assertions) {
                if (assertionMap.containsKey(key)) {
                    Object val = assertionMap.get("reachable");
                    if (result.isPresent() && !Objects.equal((Object)result.get(), (Object)val)) {
                        foundConflictingDuplicate = true;
                    } else {
                        result = Maybe.of((Object)val);
                    }
                }
                keys.addAll(assertionMap.keySet());
            }
        }
        Sets.SetView unhandledKeys = Sets.difference((Set)keys, (Set)ImmutableSet.of((Object)key));
        if (foundConflictingDuplicate) {
            throw new IllegalArgumentException("Multiple conflicting values for assertion '" + key + "' in " + this);
        }
        if (unhandledKeys.size() > 0) {
            throw new IllegalArgumentException("Unknown assertions " + unhandledKeys + " in " + this);
        }
        return result;
    }

    protected HostAndPort toHostAndPort(Object endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("The entity [%s] has no endpoint", this.getClass().getName()));
        }
        if (endpoint instanceof String) {
            return this.toHostAndPort((String)endpoint);
        }
        if (endpoint instanceof URI) {
            return this.toHostAndPort(((URI)endpoint).toString());
        }
        if (endpoint instanceof URL) {
            return this.toHostAndPort(((URL)endpoint).toString());
        }
        if (endpoint instanceof HostAndPort) {
            return (HostAndPort)endpoint;
        }
        throw new IllegalArgumentException(String.format("The entity [%s] has endpoint of invalid type %s [%s]", this.getClass().getName(), endpoint.getClass().getName(), endpoint));
    }

    protected HostAndPort toHostAndPort(String endpoint) {
        if (Strings.isEmpty((CharSequence)endpoint)) {
            throw new IllegalArgumentException(String.format("The entity [%s] has no endpoint", this.getClass().getName()));
        }
        try {
            int port;
            URI uri = URI.create(endpoint);
            if (uri.getPort() != -1) {
                port = uri.getPort();
            } else if ("http".equalsIgnoreCase(uri.getScheme())) {
                port = 80;
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                port = 443;
            } else {
                throw new IllegalArgumentException(String.format("The entity [%s] with endpoint [%s] has no port", this.getClass().getName(), endpoint));
            }
            return HostAndPort.fromParts((String)uri.getHost(), (int)port);
        }
        catch (IllegalArgumentException uri) {
            HostAndPort result = HostAndPort.fromString((String)endpoint);
            if (!result.hasPort()) {
                throw new IllegalArgumentException(String.format("The entity [%s] with endpoint [%s] has no port", this.getClass().getName(), endpoint));
            }
            return result;
        }
    }

    public void stop() {
        this.setUpAndRunState(false, Lifecycle.STOPPED);
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }
}

