/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class DefaultCredentialsFromImageOrOverridingCredentials
implements Function<Template, LoginCredentials> {
    public LoginCredentials apply(Template template) {
        TemplateOptions options = template.getOptions();
        LoginCredentials defaultCreds = template.getImage().getDefaultCredentials();
        return DefaultCredentialsFromImageOrOverridingCredentials.overrideDefaultCredentialsWithOptionsIfPresent(defaultCreds, options);
    }

    public static LoginCredentials overrideDefaultCredentialsWithOptionsIfPresent(@Nullable LoginCredentials defaultCreds, RunScriptOptions options) {
        LoginCredentials.Builder builder = LoginCredentials.builder((Credentials)defaultCreds);
        if (options.getLoginUser() != null) {
            builder.user(options.getLoginUser());
        }
        if (options.getLoginPassword() != null) {
            builder.password(options.getLoginPassword());
        }
        if (options.getLoginPrivateKey() != null) {
            builder.privateKey(options.getLoginPrivateKey());
        }
        if (options.shouldAuthenticateSudo() != null) {
            builder.authenticateSudo(true);
        }
        return builder.build();
    }
}

