/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.winrm;

import com.google.common.annotations.Beta;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AdvertiseWinrmLoginPolicy
extends AbstractPolicy
implements SensorEventListener<Location> {
    private static final Logger LOG = LoggerFactory.getLogger(AdvertiseWinrmLoginPolicy.class);
    public static final AttributeSensor<String> VM_USER_CREDENTIALS = Sensors.newStringSensor((String)"vm.user.credentials", (String)"The \"<user> : <password> @ <hostname>:<port>\"");

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscriptions().subscribe((Entity)entity, (Sensor)AbstractEntity.LOCATION_ADDED, (SensorEventListener)this);
    }

    public void onEvent(SensorEvent<Location> event) {
        Entity entity = event.getSource();
        Location loc = (Location)event.getValue();
        if (loc instanceof WinRmMachineLocation) {
            this.advertiseUserAsync(entity, (WinRmMachineLocation)loc);
        }
    }

    protected void advertiseUserAsync(Entity entity, WinRmMachineLocation machine) {
        String user = machine.getUser();
        String hostname = machine.getHostname();
        int port = machine.getPort();
        String password = (String)machine.config().get(WinRmMachineLocation.PASSWORD);
        String creds = user + " : " + password + " @ " + hostname + ":" + port;
        LOG.info("Advertising user " + user + " @ " + hostname + ":" + port);
        entity.sensors().set(VM_USER_CREDENTIALS, (Object)creds);
    }
}

