/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.enricher.EnricherDynamicType;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.objs.BrooklynDynamicType;
import org.apache.brooklyn.core.policy.PolicyDynamicType;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class BrooklynTypes {
    private static final Cache<Class, BrooklynDynamicType<?, ?>> cache = CacheBuilder.newBuilder().weakKeys().softValues().build();

    public static EntityDynamicType getDefinedEntityType(Class<? extends Entity> entityClass) {
        return (EntityDynamicType)BrooklynTypes.getDefinedBrooklynType(entityClass);
    }

    public static BrooklynDynamicType<?, ?> getDefinedBrooklynType(Class<? extends BrooklynObject> brooklynClass) {
        try {
            return (BrooklynDynamicType)cache.get(brooklynClass, (Callable)new DefinedBrooklynTypeLoader(brooklynClass));
        }
        catch (ExecutionException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static Map<String, ConfigKey<?>> getDefinedConfigKeys(Class<? extends BrooklynObject> brooklynClass) {
        return BrooklynTypes.getDefinedBrooklynType(brooklynClass).getConfigKeys();
    }

    public static Map<String, ConfigKey<?>> getDefinedConfigKeys(String brooklynTypeName) {
        try {
            return BrooklynTypes.getDefinedConfigKeys(new ClassLoaderUtils(BrooklynTypes.class).loadClass(brooklynTypeName));
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static Map<String, Sensor<?>> getDefinedSensors(Class<? extends Entity> entityClass) {
        return BrooklynTypes.getDefinedEntityType(entityClass).getSensors();
    }

    public static Map<String, Sensor<?>> getDefinedSensors(String entityTypeName) {
        try {
            return BrooklynTypes.getDefinedSensors(new ClassLoaderUtils(BrooklynTypes.class).loadClass(entityTypeName));
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static class DefinedBrooklynTypeLoader
    implements Callable<BrooklynDynamicType<?, ?>> {
        private Class<?> brooklynClass;

        public DefinedBrooklynTypeLoader(Class<?> type) {
            this.brooklynClass = type;
        }

        @Override
        public BrooklynDynamicType<?, ?> call() throws Exception {
            if (Entity.class.isAssignableFrom(this.brooklynClass)) {
                return new ImmutableEntityType((Class<? extends Entity>)this.brooklynClass);
            }
            if (Location.class.isAssignableFrom(this.brooklynClass)) {
                return new ImmutableEntityType((Class<? extends Entity>)this.brooklynClass);
            }
            if (Policy.class.isAssignableFrom(this.brooklynClass)) {
                return new PolicyDynamicType((Class<? extends Policy>)this.brooklynClass);
            }
            if (Enricher.class.isAssignableFrom(this.brooklynClass)) {
                return new EnricherDynamicType((Class<? extends Enricher>)this.brooklynClass);
            }
            throw new IllegalStateException("Invalid brooklyn type " + this.brooklynClass);
        }
    }

    private static class ImmutableEntityType
    extends EntityDynamicType {
        public ImmutableEntityType(Class<? extends Entity> clazz) {
            super(clazz);
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSensor(Sensor<?> newSensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSensorIfAbsent(Sensor<?> newSensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Sensor<?> addSensorIfAbsentWithoutPublishing(Sensor<?> newSensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSensors(Iterable<? extends Sensor<?>> newSensors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeSensor(Sensor<?> sensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Sensor<?> removeSensor(String sensorName) {
            throw new UnsupportedOperationException();
        }
    }
}

