/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi.model;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.module.ClientAuthModule;
import javax.security.auth.message.module.ServerAuthModule;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.geronimo.components.jaspi.model.AuthModuleType;
import org.apache.geronimo.components.jaspi.model.ClientAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ClientAuthContextType;
import org.apache.geronimo.components.jaspi.model.ConfigProviderType;
import org.apache.geronimo.components.jaspi.model.JaspiType;
import org.apache.geronimo.components.jaspi.model.KeyedObjectMapAdapter;
import org.apache.geronimo.components.jaspi.model.ObjectFactory;
import org.apache.geronimo.components.jaspi.model.ServerAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ServerAuthContextType;
import org.xml.sax.SAXException;

public class JaspiXmlUtil {
    public static final XMLInputFactory XMLINPUT_FACTORY = XMLInputFactory.newInstance();
    public static final JAXBContext JASPI_CONTEXT;

    public static void initialize(CallbackHandler callbackHandler) {
        KeyedObjectMapAdapter.staticCallbackHandler = callbackHandler;
    }

    public static <T> void write(JAXBElement<T> element, Writer out) throws JAXBException {
        Marshaller marshaller = JASPI_CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(element, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(Reader in, Class<T> clazz) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        try {
            T t = JaspiXmlUtil.load(xmlStream, clazz);
            return t;
        }
        finally {
            xmlStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object untypedLoad(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        XMLStreamReader xmlStream = XMLINPUT_FACTORY.createXMLStreamReader(in);
        try {
            Object object = JaspiXmlUtil.untypedLoad(xmlStream);
            return object;
        }
        finally {
            xmlStream.close();
        }
    }

    public static <T> T load(XMLStreamReader in, Class<T> clazz) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = JASPI_CONTEXT.createUnmarshaller();
        JAXBElement element = unmarshaller.unmarshal(in, clazz);
        return (T)element.getValue();
    }

    public static Object untypedLoad(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        Unmarshaller unmarshaller = JASPI_CONTEXT.createUnmarshaller();
        return unmarshaller.unmarshal(in);
    }

    public static void writeJaspi(JaspiType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createJaspi(metadata), out);
    }

    public static JaspiType loadJaspi(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, JaspiType.class);
    }

    public static JaspiType loadJaspi(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, JaspiType.class);
    }

    public static void writeConfigProvider(ConfigProviderType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createConfigProvider(metadata), out);
    }

    public static ConfigProviderType loadConfigProvider(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ConfigProviderType.class);
    }

    public static ConfigProviderType loadConfigProvider(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ConfigProviderType.class);
    }

    public static void writeClientAuthConfig(ClientAuthConfigType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createClientAuthConfig(metadata), out);
    }

    public static ClientAuthConfigType loadClientAuthConfig(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ClientAuthConfigType.class);
    }

    public static ClientAuthConfigType loadClientAuthConfig(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ClientAuthConfigType.class);
    }

    public static void writeClientAuthContext(ClientAuthContextType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createClientAuthContext(metadata), out);
    }

    public static ClientAuthContextType loadClientAuthContext(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ClientAuthContextType.class);
    }

    public static ClientAuthContextType loadClientAuthContext(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ClientAuthContextType.class);
    }

    public static void writeClientAuthModule(AuthModuleType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createClientAuthModule(metadata), out);
    }

    public static AuthModuleType<ClientAuthModule> loadClientAuthModule(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, AuthModuleType.class);
    }

    public static AuthModuleType<ClientAuthModule> loadClientAuthModule(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, AuthModuleType.class);
    }

    public static void writeServerAuthConfig(ServerAuthConfigType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createServerAuthConfig(metadata), out);
    }

    public static ServerAuthConfigType loadServerAuthConfig(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ServerAuthConfigType.class);
    }

    public static ServerAuthConfigType loadServerAuthConfig(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ServerAuthConfigType.class);
    }

    public static void writeServerAuthContext(ServerAuthContextType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createServerAuthContext(metadata), out);
    }

    public static ServerAuthContextType loadServerAuthContext(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ServerAuthContextType.class);
    }

    public static ServerAuthContextType loadServerAuthContext(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, ServerAuthContextType.class);
    }

    public static void writeServerAuthModule(AuthModuleType metadata, Writer out) throws XMLStreamException, JAXBException {
        JaspiXmlUtil.write(new ObjectFactory().createServerAuthModule(metadata), out);
    }

    public static AuthModuleType<ServerAuthModule> loadServerAuthModule(Reader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, AuthModuleType.class);
    }

    public static AuthModuleType<ServerAuthModule> loadServerAuthModule(XMLStreamReader in) throws ParserConfigurationException, IOException, SAXException, JAXBException, XMLStreamException {
        return JaspiXmlUtil.load(in, AuthModuleType.class);
    }

    static {
        try {
            JASPI_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{JaspiType.class, ConfigProviderType.class, ClientAuthConfigType.class, ClientAuthContextType.class, ServerAuthConfigType.class, ServerAuthContextType.class, AuthModuleType.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create jaxb contexts for plugin types", e);
        }
    }
}

