/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.extensions.ServiceAdminApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseServices
extends ParseJson<Services> {
    @Inject
    public ParseServices(Json json) {
        super(json, TypeLiteral.get(Services.class));
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Service, ToPagedIterable> {
        private final KeystoneApi api;

        @Inject
        protected ToPagedIterable(KeystoneApi api) {
            this.api = (KeystoneApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Service>> markerToNextForArg0(Optional<Object> ignored) {
            final ServiceAdminApi serviceApi = (ServiceAdminApi)this.api.getServiceAdminApi().get();
            return new Function<Object, IterableWithMarker<Service>>(){

                public IterableWithMarker<Service> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)((Object)PaginationOptions.class.cast(input));
                    return (IterableWithMarker)IterableWithMarker.class.cast(serviceApi.list(paginationOptions));
                }

                public String toString() {
                    return "listServices()";
                }
            };
        }
    }

    static class Services
    extends PaginatedCollection<Service> {
        @ConstructorProperties(value={"OS-KSADM:services", "services_links"})
        protected Services(Iterable<Service> services, Iterable<Link> services_links) {
            super(services, services_links);
        }
    }
}

