/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.net.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class IpPermissions
extends IpPermission {
    protected IpPermissions(IpProtocol ipProtocol, int fromPort, int toPort, Multimap<String, String> tenantIdGroupPairs, Iterable<String> groupIds, Iterable<String> cidrBlocks, Iterable<String> exclusionCidrBlocks) {
        super(ipProtocol, fromPort, toPort, tenantIdGroupPairs, groupIds, (Iterable<String>)(tenantIdGroupPairs.size() == 0 ? cidrBlocks : ImmutableSet.of()), (Iterable<String>)(tenantIdGroupPairs.size() == 0 ? exclusionCidrBlocks : ImmutableSet.of()));
    }

    public static ICMPTypeSelection permitICMP() {
        return new ICMPTypeSelection();
    }

    public static ToSourceSelection permitAnyProtocol() {
        return new ToSourceSelection(IpProtocol.ALL, 1, 65535);
    }

    public static PortSelection permit(IpProtocol protocol) {
        return new PortSelection((IpProtocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol")));
    }

    public static class ToSourceSelection
    extends ToGroupSourceSelection {
        ToSourceSelection(IpProtocol ipProtocol, int fromPort, int toPort) {
            super(ipProtocol, fromPort, toPort);
        }

        public IpPermissions originatingFromCidrBlock(String cidrIp) {
            return this.originatingFromCidrBlocks((Iterable<String>)ImmutableSet.of((Object)((String)Preconditions.checkNotNull((Object)cidrIp, (Object)"cidrIp"))));
        }

        public IpPermissions originatingFromCidrBlocks(Iterable<String> cidrIps) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), (Multimap<String, String>)ImmutableMultimap.of(), (Iterable<String>)ImmutableSet.of(), cidrIps, (Iterable<String>)ImmutableSet.of());
        }

        public IpPermissions exceptOriginatingFromCidrBlock(String excludedCidrIp) {
            return this.exceptOriginatingFromCidrBlocks((Iterable<String>)ImmutableSet.of((Object)((String)Preconditions.checkNotNull((Object)excludedCidrIp, (Object)"excludedCidrIp"))));
        }

        public IpPermissions exceptOriginatingFromCidrBlocks(Iterable<String> excludedCidrIps) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), (Multimap<String, String>)ImmutableMultimap.of(), (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of(), excludedCidrIps);
        }

        public IpPermissions originatingFromTenantAndSecurityGroup(String tenantId, String groupName) {
            return this.toTenantsGroupsNamed((Multimap<String, String>)ImmutableMultimap.of((Object)((String)Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId")), (Object)((String)Preconditions.checkNotNull((Object)groupName, (Object)"groupName"))));
        }

        public IpPermissions toTenantsGroupsNamed(Multimap<String, String> tenantIdGroupNamePairs) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), tenantIdGroupNamePairs, this.getGroupIds(), (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of());
        }
    }

    public static class ToGroupSourceSelection
    extends IpPermissions {
        protected ToGroupSourceSelection(IpProtocol ipProtocol, int fromPort, int toPort) {
            super(ipProtocol, fromPort, toPort, (Multimap<String, String>)ImmutableMultimap.of(), (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of((Object)"0.0.0.0/0"), (Iterable<String>)ImmutableSet.of());
        }

        public IpPermissions originatingFromSecurityGroupId(String groupId) {
            return this.originatingFromSecurityGroupIds((Iterable<String>)ImmutableSet.of((Object)((String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId"))));
        }

        public IpPermissions originatingFromSecurityGroupIds(Iterable<String> groupIds) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), this.getTenantIdGroupNamePairs(), groupIds, (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of());
        }
    }

    public static class ToPortSelection
    extends ToSourceSelection {
        ToPortSelection(IpProtocol ipProtocol, int fromPort) {
            super(ipProtocol, fromPort, ipProtocol == IpProtocol.ICMP ? -1 : 65535);
        }

        public ToSourceSelection to(int port) {
            return new ToSourceSelection(this.getIpProtocol(), this.getFromPort(), port);
        }
    }

    public static class PortSelection
    extends ToSourceSelection {
        PortSelection(IpProtocol ipProtocol) {
            super(ipProtocol, ipProtocol == IpProtocol.ICMP ? -1 : 1, ipProtocol == IpProtocol.ICMP ? -1 : 65535);
        }

        public ToPortSelection fromPort(int port) {
            return new ToPortSelection(this.getIpProtocol(), port);
        }

        public ToSourceSelection port(int port) {
            return new ToSourceSelection(this.getIpProtocol(), port, port);
        }
    }

    public static class AndCodeSelection
    extends ToSourceSelection {
        AndCodeSelection(int type) {
            super(IpProtocol.ICMP, type, -1);
        }

        public ToSourceSelection andCode(int code) {
            return new ToSourceSelection(this.getIpProtocol(), this.getFromPort(), code);
        }
    }

    public static class ICMPTypeSelection
    extends ToSourceSelection {
        ICMPTypeSelection() {
            super(IpProtocol.ICMP, -1, -1);
        }

        public AndCodeSelection type(int type) {
            return new AndCodeSelection(type);
        }
    }
}

