/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.core.mgmt.internal.AppGroupTraverser;
import org.apache.brooklyn.core.resolve.jackson.PrimitiveTokenOrExpectedObject;
import org.apache.brooklyn.core.sensor.AbstractAddSensorFeed;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.apache.commons.lang3.tuple.Pair;

@Beta
public abstract class AbstractAddTriggerableSensor<T>
extends AbstractAddSensorFeed<T> {
    public static final ConfigKey<Duration> SENSOR_PERIOD = ConfigKeys.newConfigKey(Duration.class, "period", "Period, including units e.g. 1m or 5s or 200ms", null);
    public static final ConfigKey<Object> SENSOR_TRIGGERS = ConfigKeys.newConfigKey(new TypeToken<Object>(){}, "triggers", "Sensors which should trigger this feed, supplied with list of maps containing sensor (name or sensor instance) and entity (ID or entity instance), or just sensor names or just one sensor");
    public static final ConfigKey<Boolean> SKIP_INITIAL_RUN = ConfigKeys.newConfigKey(Boolean.class, "skip_initial_run", "If set, skips running when added; runs only after the period or on a subsequent trigger");
    public static final ConfigKey<DslPredicates.DslPredicate> CONDITION = ConfigKeys.newConfigKey(DslPredicates.DslPredicate.class, "condition", "Optional condition required for this sensor feed to run");
    public static final ConfigKey<Boolean> ONLY_IF_SERVICE_UP = ConfigKeys.newBooleanConfigKey("onlyIfServiceUp", "Whether to run only if service is up.", null);

    protected AbstractAddTriggerableSensor() {
    }

    public AbstractAddTriggerableSensor(ConfigBag parameters) {
        super(parameters);
    }

    @JsonIgnore
    protected Duration getPeriod(Entity context, ConfigBag config) {
        if (config.containsKey(SENSOR_PERIOD) || !this.hasTriggers(config)) {
            if (context != null) {
                return Tasks.resolving(config, SENSOR_PERIOD).context(context).immediately(true).get();
            }
            return config.get(SENSOR_PERIOD);
        }
        return Duration.PRACTICALLY_FOREVER;
    }

    @JsonIgnore
    protected Maybe<Object> getTriggersMaybe(Entity context, ConfigBag config) {
        return Tasks.resolving(config, SENSOR_TRIGGERS).context(context).deep().immediately(true).getMaybe();
    }

    @Beta
    public static List<Pair<Entity, Sensor>> resolveTriggers(Entity context, Object otherTriggers) {
        Object triggers = Tasks.resolving(otherTriggers, Object.class).context(context).deep().immediately(true).get();
        if (triggers == null || triggers instanceof Collection && ((Collection)triggers).isEmpty()) {
            return Collections.emptyList();
        }
        if (triggers instanceof String) {
            SensorFeedTrigger t = new SensorFeedTrigger();
            t.sensorName = (String)triggers;
            triggers = MutableList.of((Object)t);
        }
        if (!(triggers instanceof Collection)) {
            throw new IllegalStateException("Triggers should be a list containing sensors or sensor names");
        }
        return ((Collection)triggers).stream().map(ti -> {
            AttributeSensor<Object> sensor;
            SensorFeedTrigger t;
            if (ti instanceof SensorFeedTrigger) {
                t = (SensorFeedTrigger)ti;
            } else if (ti instanceof Map) {
                t = Tasks.resolving(ti, SensorFeedTrigger.class).context(context).deep().get();
            } else {
                if (!(ti instanceof String)) throw new IllegalStateException("Trigger should be a map specifying entity and sensor");
                t = new SensorFeedTrigger();
                t.sensorName = (String)ti;
            }
            Entity entity = t.entity;
            if (entity == null) {
                if (t.entityId != null) {
                    String desiredComponentId = t.entityId;
                    List<Entity> firstGroupOfMatches = AppGroupTraverser.findFirstGroupOfMatches(context, true, arg_0 -> ((Predicate)Predicates.and(EntityPredicates.configEqualTo(BrooklynConfigKeys.PLAN_ID, desiredComponentId), x -> true)).apply(arg_0));
                    if (firstGroupOfMatches.isEmpty()) {
                        firstGroupOfMatches = AppGroupTraverser.findFirstGroupOfMatches(context, true, arg_0 -> ((Predicate)Predicates.and(EntityPredicates.idEqualTo(desiredComponentId), x -> true)).apply(arg_0));
                    }
                    if (firstGroupOfMatches.isEmpty()) throw new IllegalStateException("Cannot find entity with ID '" + desiredComponentId + "'");
                    entity = firstGroupOfMatches.get(0);
                } else {
                    entity = context;
                }
            }
            if ((sensor = t.sensor) != null) return Pair.of((Object)entity, sensor);
            if (t.sensorName == null) throw new IllegalStateException("Sensor is required for a trigger");
            sensor = entity.getEntityType().getSensor(t.sensorName);
            if (sensor != null) return Pair.of((Object)entity, sensor);
            sensor = Sensors.newSensor(Object.class, t.sensorName);
            return Pair.of((Object)entity, sensor);
        }).collect(Collectors.toList());
    }

    protected boolean hasTriggers(ConfigBag config) {
        Maybe<Object> triggers = this.getTriggersMaybe(null, config);
        if (triggers == null || triggers.isAbsent()) {
            return false;
        }
        return !(triggers.get() instanceof Collection) || !((Collection)triggers.get()).isEmpty();
    }

    protected void standardPollConfig(Entity entity, ConfigBag configBag, PollConfig<?, ?, ?> poll) {
        Boolean suppressDuplicates = (Boolean)EntityInitializers.resolve(configBag, SUPPRESS_DUPLICATES);
        Duration logWarningGraceTimeOnStartup = (Duration)EntityInitializers.resolve(configBag, LOG_WARNING_GRACE_TIME_ON_STARTUP);
        Duration logWarningGraceTime = (Duration)EntityInitializers.resolve(configBag, LOG_WARNING_GRACE_TIME);
        ((PollConfig)((PollConfig)((PollConfig)((PollConfig)((PollConfig)((PollConfig)poll.suppressDuplicates(Boolean.TRUE.equals(suppressDuplicates))).logWarningGraceTimeOnStartup(logWarningGraceTimeOnStartup)).logWarningGraceTime(logWarningGraceTime)).period(this.getPeriod(entity, this.initParams()))).skipInitialRun(this.initParam(SKIP_INITIAL_RUN))).otherTriggers(this.getTriggersMaybe(entity, configBag).orNull())).condition(new ConditionSupplierFromConfigBag(configBag, entity));
        if (!Boolean.FALSE.equals(configBag.get(FAIL_TASK_ON_ERROR))) {
            poll.onException(new RethrowException());
        }
    }

    public static class RethrowException<T>
    implements Function<Throwable, T> {
        public T apply(Throwable err) {
            throw Exceptions.propagate((Throwable)err);
        }
    }

    static class ConditionSupplierFromConfigBag
    implements Supplier<DslPredicates.DslPredicate> {
        final ConfigBag configBag;
        final Entity entity;

        ConditionSupplierFromConfigBag(ConfigBag configBag, Entity entity) {
            this.configBag = configBag;
            this.entity = entity;
        }

        @Override
        public DslPredicates.DslPredicate get() {
            return Tasks.resolving(this.configBag, CONDITION).context(this.entity).deep().immediately(true).get();
        }
    }

    public static class SensorFeedTrigger {
        Entity entity;
        @JsonIgnore
        String entityId;
        Sensor<?> sensor;
        @JsonIgnore
        String sensorName;

        @JsonSetter
        public void setEntity(PrimitiveTokenOrExpectedObject<Entity> po) {
            if (po.hasObject()) {
                this.setEntity(po.asObject());
            } else if (po.hasStringPrimitive()) {
                this.setEntity(po.asString());
            } else if (this.entity != null) {
                throw new IllegalArgumentException("Invalid input for entity to " + this + ": " + this.entity);
            }
        }

        public void setEntity(Entity entity) {
            this.entity = entity;
        }

        public void setEntity(String entityId) {
            this.entityId = entityId;
        }

        public Object getEntity() {
            return this.entity != null ? this.entity : this.entityId;
        }

        public void setSensor(Sensor<?> sensor) {
            this.sensor = sensor;
        }

        public void setSensor(String sensorName) {
            this.sensorName = sensorName;
        }

        public Object getSensor() {
            return this.sensor != null ? this.sensor : this.sensorName;
        }
    }
}

