/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.entity.group.DynamicGroupImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=DynamicGroupImpl.class)
public interface DynamicGroup
extends AbstractGroup {
    @SetFromFlag(value="entityFilter")
    public static final ConfigKey<Predicate<? super Entity>> ENTITY_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<? super Entity>>(){}, "dynamicgroup.entityfilter", "Filter for entities which will automatically be in the group");
    public static final ConfigKey<Entity> ANCESTOR = ConfigKeys.newConfigKey(Entity.class, "dynamicgroup.ancestor", "Ancestor (or application) under which to search, or null to use containing application");
    public static final AttributeSensor<Boolean> RUNNING = Sensors.newBooleanSensor("dynamicgroup.running", "Whether the entity is running, and will automatically update group membership");
    public static final MethodEffector<Void> RESCAN_EFFECTOR = new MethodEffector(DynamicGroup.class, "rescanEntities");

    @Deprecated
    public void stop();

    @Effector(description="Rescans all entities to determine whether they match the configured filter.")
    public void rescanEntities();

    public void setEntityFilter(Predicate<? super Entity> var1);

    public <T> void addSubscription(Entity var1, Sensor<T> var2, Predicate<? super SensorEvent<? super T>> var3);

    public <T> void addSubscription(Entity var1, Sensor<T> var2);

    @Deprecated
    public Predicate<? super Entity> entityFilter();
}

