/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.workflow.steps.CustomWorkflowStep;
import org.apache.brooklyn.entity.group.BasicGroup;
import org.apache.brooklyn.entity.group.DynamicGroupImpl;
import org.apache.brooklyn.entity.group.DynamicMultiGroup;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMultiGroupImpl
extends DynamicGroupImpl
implements DynamicMultiGroup {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMultiGroupImpl.class);
    private transient FunctionFeed rescan;

    public static Function<Entity, String> bucketFromAttribute(AttributeSensor<?> sensor, String defaultValue) {
        return new BucketFromAttribute(sensor, defaultValue);
    }

    public static Function<Entity, String> bucketFromAttribute(AttributeSensor<?> sensor) {
        return DynamicMultiGroupImpl.bucketFromAttribute(sensor, null);
    }

    @Override
    public void init() {
        super.init();
        this.sensors().set(BUCKETS, ImmutableMap.of());
        this.connectScanner();
    }

    @Override
    protected void initEnrichers() {
        super.initEnrichers();
        this.enrichers().add(ServiceStateLogic.newEnricherFromChildrenState().checkChildrenOnly().requireRunningChildren((QuorumCheck)this.getConfig(RUNNING_QUORUM_CHECK)).suppressDuplicates(true));
        this.enrichers().add(ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenOnly().requireUpChildren((QuorumCheck)this.getConfig(UP_QUORUM_CHECK)).suppressDuplicates(true));
    }

    private void connectScanner() {
        Long interval = (Long)this.getConfig(RESCAN_INTERVAL);
        if (interval != null && interval > 0L) {
            this.rescan = FunctionFeed.builder().uniqueTag("dynamic-multi-group-scanner").entity(this).poll(((FunctionPollConfig)new FunctionPollConfig(RESCAN).period(interval, TimeUnit.SECONDS)).callable(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DynamicMultiGroupImpl.this.rescanEntities();
                    return null;
                }
            })).build(true);
        }
    }

    @Override
    public void rebind() {
        super.rebind();
        if (this.rescan == null) {
            this.getExecutionContext().execute(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("Deferring scanner for {} until management context initialisation complete", (Object)DynamicMultiGroupImpl.this);
                    while (!this.isRebindComplete()) {
                        Time.sleep((long)100L);
                    }
                    LOG.debug("Connecting scanner for {}", (Object)DynamicMultiGroupImpl.this);
                    DynamicMultiGroupImpl.this.connectScanner();
                }

                private boolean isRebindComplete() {
                    Map metrics = DynamicMultiGroupImpl.this.getManagementContext().getRebindManager().getMetrics();
                    Object count = metrics.get("rebind") instanceof Map ? ((Map)metrics.get("rebind")).get("count") : null;
                    return count instanceof Number && ((Number)count).intValue() > 0;
                }
            });
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.rescan != null && this.rescan.isActivated()) {
            this.rescan.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEntityAdded(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.onEntityAdded(item);
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEntityRemoved(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.onEntityRemoved(item);
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEntityChanged(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.onEntityChanged(item);
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rescanEntities() {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.rescanEntities();
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void distributeEntities() {
        try {
            Object object = this.memberChangeMutex;
            synchronized (object) {
                EntitySpec bucketSpec;
                if (Entities.isUnmanagingOrNoLongerManaged(this)) {
                    return;
                }
                Function bucketFunctionF = (Function)this.getConfig(BUCKET_FUNCTION);
                CustomWorkflowStep bucketFunctionW = (CustomWorkflowStep)this.getConfig(BUCKET_WORKFLOW);
                String bucketFunctionE = (String)this.getConfig(BUCKET_EXPRESSION);
                if (bucketFunctionE != null) {
                    if (bucketFunctionW != null) {
                        LOG.warn("Ignoring bucket workflow because expression supplied");
                    }
                    bucketFunctionW = TypeCoercions.coerce((Object)MutableMap.of((Object)"steps", (Object)MutableList.of((Object)("return " + bucketFunctionE))), CustomWorkflowStep.class);
                }
                if (bucketFunctionW != null) {
                    if (bucketFunctionF != null) {
                        LOG.warn("Ignoring bucket function because workflow or expression supplied");
                    }
                    bucketFunctionF = new WorkflowFunction(bucketFunctionW);
                }
                Function bucketIdFunctionF = (Function)this.getConfig(BUCKET_ID_FUNCTION);
                CustomWorkflowStep bucketIdFunctionW = (CustomWorkflowStep)this.getConfig(BUCKET_ID_WORKFLOW);
                String bucketIdFunctionE = (String)this.getConfig(BUCKET_ID_EXPRESSION);
                if (bucketIdFunctionE != null) {
                    if (bucketIdFunctionW != null) {
                        LOG.warn("Ignoring bucket workflow because expression supplied");
                    }
                    bucketIdFunctionW = TypeCoercions.coerce((Object)MutableMap.of((Object)"steps", (Object)MutableList.of((Object)("return " + bucketIdFunctionE))), CustomWorkflowStep.class);
                }
                if (bucketIdFunctionW != null) {
                    if (bucketIdFunctionF != null) {
                        LOG.warn("Ignoring bucket function because workflow or expression supplied");
                    }
                    bucketIdFunctionF = new WorkflowFunction(bucketIdFunctionW);
                }
                if (bucketFunctionF == null) {
                    if (bucketIdFunctionF != null) {
                        bucketFunctionF = bucketIdFunctionF;
                    } else {
                        LOG.warn(this + " should have exactly one of: a bucket expression, workflow, or function (optionally coming from the bucket ID function)");
                        return;
                    }
                }
                if ((bucketSpec = (EntitySpec)this.getConfig(BUCKET_SPEC)) == null) {
                    return;
                }
                MutableMap buckets = MutableMap.copyOf((Map)((Map)this.getAttribute(BUCKETS)));
                Function bucketFunctionF2 = bucketFunctionF;
                Multimap entityMapping = (Multimap)this.getMembers().stream().collect(() -> Multimaps.newSetMultimap((Map)MutableMap.of(), MutableSet::new), (map, entity) -> {
                    String name = (String)bucketFunctionF2.apply(entity);
                    if (Strings.isNonBlank((CharSequence)name)) {
                        map.put((Object)name, entity);
                    }
                }, (m1, m2) -> m1.putAll((Multimap)m2));
                Collection<Entity> oldChildren = this.getChildren();
                for (String name : entityMapping.keySet()) {
                    BasicGroup bucket = (BasicGroup)buckets.get(name);
                    if (bucket == null) {
                        try {
                            EntitySpec spec = (EntitySpec)EntitySpec.create((EntitySpec)bucketSpec).displayName(name);
                            if (bucketIdFunctionF != null) {
                                spec.configure(BrooklynConfigKeys.PLAN_ID, bucketIdFunctionF.apply(entityMapping.get((Object)name).iterator().next()));
                            }
                            bucket = (BasicGroup)this.addChild(spec);
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this, "children", (Object)("Could not add child; removing all new children for now: " + Exceptions.collapseText((Throwable)e)));
                            MutableSet newChildren = MutableSet.copyOf(this.getChildren());
                            newChildren.removeAll(oldChildren);
                            for (Entity child : newChildren) {
                                this.removeChild(child);
                            }
                            throw e;
                        }
                        ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this, "children");
                        buckets.put(name, bucket);
                    }
                    bucket.setMembers(entityMapping.get((Object)name));
                }
                ImmutableSet empty = ImmutableSet.copyOf((Collection)Sets.difference(buckets.keySet(), (Set)entityMapping.keySet()));
                for (String name : empty) {
                    Group removed = (Group)buckets.remove(name);
                    LOG.debug(this + " removing empty child-bucket " + name + " -> " + removed);
                    this.removeChild((Entity)removed);
                    Entities.unmanage((Entity)removed);
                }
                this.sensors().set(BUCKETS, ImmutableMap.copyOf((Map)buckets));
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (Entities.isUnmanagingOrNoLongerManaged(this)) {
                LOG.debug("Error in " + this + " when unmanaged, ignoring: " + e);
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static class WorkflowFunction
    implements Function<Entity, String> {
        private final CustomWorkflowStep workflow;

        public WorkflowFunction(CustomWorkflowStep bucketFunctionW) {
            this.workflow = bucketFunctionW;
        }

        public String apply(Entity entity) {
            Maybe<Task<Object>> t = this.workflow.newWorkflowExecution(entity, "Workflow to find bucket name for " + entity, null).getTask(true);
            if (t.isAbsent()) {
                LOG.debug("Entity " + entity + " does not match condition to placed in the dynamic multigroup");
                return null;
            }
            try {
                return TypeCoercions.coerce(DynamicTasks.submit((TaskAdaptable)t.get(), entity).getUnchecked(), String.class);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Entity " + entity + " failed when trying to evaluate the bucket it goes in; not putting into a bucket");
                return null;
            }
        }
    }

    public static class BucketFromAttribute
    implements Function<Entity, String> {
        private final AttributeSensor<?> sensor;
        private final String defaultValue;

        public BucketFromAttribute(AttributeSensor<?> sensor, String defaultValue) {
            this.sensor = (AttributeSensor)Preconditions.checkNotNull(sensor, (Object)"sensor");
            this.defaultValue = defaultValue;
        }

        public String apply(@Nullable Entity input) {
            Object value = input.getAttribute(this.sensor);
            if (value == null) {
                return this.defaultValue;
            }
            return String.valueOf(value);
        }
    }
}

