/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.file;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.ssh.IptablesCommandsConfigurable;

public class BrooklynOsCommands {
    public static final ConfigKey<Boolean> SSH_CONFIG_SCRIPT_IGNORE_CERTS = BrooklynConfigKeys.SSH_CONFIG_SCRIPTS_IGNORE_CERTS;
    public static final ConfigKey<Boolean> SCRIPT_IGNORE_CERTS = ConfigKeys.newConfigKeyWithPrefixRemoved("brooklyn.ssh.config.", SSH_CONFIG_SCRIPT_IGNORE_CERTS);

    public static BashCommandsConfigurable bash(ManagementContext mgmt) {
        return BashCommandsConfigurable.newInstance().withIgnoreCerts(((ManagementContextInternal)mgmt).getBrooklynProperties().getConfig(SSH_CONFIG_SCRIPT_IGNORE_CERTS));
    }

    public static IptablesCommandsConfigurable bashIptables(ManagementContext mgmt) {
        return new IptablesCommandsConfigurable(BrooklynOsCommands.bash(mgmt));
    }

    public static BashCommandsConfigurable bash(Entity entity, boolean includeMachineLocations) {
        return BrooklynOsCommands.bashForBrooklynObjects(includeMachineLocations, new BrooklynObject[]{entity});
    }

    public static BashCommandsConfigurable bash(Location location) {
        return BrooklynOsCommands.bashForBrooklynObjects(false, new BrooklynObject[]{location});
    }

    public static BashCommandsConfigurable bashForBrooklynObjects(boolean includeMachineLocations, BrooklynObject ... brooklynObjects) {
        return BrooklynOsCommands.bashForBrooklynObjects(includeMachineLocations, Arrays.asList(brooklynObjects));
    }

    public static BashCommandsConfigurable bashForBrooklynObjects(boolean includeMachineLocations, List<BrooklynObject> brooklynObjects0) {
        ManagementContext mgmt = null;
        MutableList brooklynObjects = MutableList.of();
        for (BrooklynObject bo : brooklynObjects0) {
            if (includeMachineLocations && bo instanceof Entity) {
                brooklynObjects.addAll(((Entity)bo).getLocations().stream().filter(l -> l instanceof MachineLocation).collect(Collectors.toList()));
            }
            brooklynObjects.add(bo);
        }
        for (BrooklynObject bo : brooklynObjects) {
            Boolean ignoreCerts = null;
            if (bo instanceof Location) {
                ignoreCerts = (Boolean)bo.config().get(SCRIPT_IGNORE_CERTS);
            }
            if (ignoreCerts == null) {
                ignoreCerts = (Boolean)bo.config().get(SSH_CONFIG_SCRIPT_IGNORE_CERTS);
            }
            if (ignoreCerts != null) {
                return BashCommandsConfigurable.newInstance().withIgnoreCerts(ignoreCerts);
            }
            if (mgmt != null) continue;
            mgmt = ((BrooklynObjectInternal)bo).getManagementContext();
        }
        return BrooklynOsCommands.bash(mgmt);
    }

    public static IptablesCommandsConfigurable bashIptables(BrooklynObject entityOrOtherBrooklynObject) {
        return new IptablesCommandsConfigurable(BrooklynOsCommands.bashForBrooklynObjects(true, entityOrOtherBrooklynObject));
    }
}

