/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.brooklyn.rest.domain.HasName;

public class EffectorSummary
implements HasName,
Serializable {
    private static final long serialVersionUID = 8103535211378449509L;
    private final String name;
    private final String returnType;
    private final Set<ParameterSummary<?>> parameters;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String description;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, URI> links;

    public EffectorSummary(@JsonProperty(value="name") String name, @JsonProperty(value="returnType") String returnType, @JsonProperty(value="parameters") Set<ParameterSummary<?>> parameters, @JsonProperty(value="description") String description, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = name;
        this.description = description;
        this.returnType = returnType;
        this.parameters = parameters;
        this.links = links != null ? ImmutableMap.copyOf(links) : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Set<ParameterSummary<?>> getParameters() {
        return this.parameters;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EffectorSummary)) {
            return false;
        }
        EffectorSummary that = (EffectorSummary)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.description, that.description) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.parameters, this.description, this.links);
    }

    public String toString() {
        return "EffectorSummary{name='" + this.name + '\'' + ", returnType='" + this.returnType + '\'' + ", parameters=" + this.parameters + ", description='" + this.description + '\'' + ", links=" + this.links + '}';
    }

    public static class ParameterSummary<T>
    implements HasName,
    Serializable {
        private static final long serialVersionUID = -6393686096290306153L;
        private final String name;
        private final String type;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final String description;
        private final T defaultValue;
        private final boolean shouldSanitize;

        public ParameterSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") T defaultValue, @JsonProperty(value="shouldSanitize") boolean shouldSanitize) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
            this.shouldSanitize = shouldSanitize;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean shouldSanitize() {
            return this.shouldSanitize;
        }

        public String getDescription() {
            return this.description;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterSummary that = (ParameterSummary)o;
            return com.google.common.base.Objects.equal((Object)this.name, (Object)that.name) && com.google.common.base.Objects.equal((Object)this.type, (Object)that.type) && com.google.common.base.Objects.equal((Object)this.description, (Object)that.description) && com.google.common.base.Objects.equal(this.defaultValue, that.defaultValue);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.name, this.type, this.description, this.defaultValue});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("description", (Object)this.description).add("defaultValue", this.defaultValue).toString();
        }
    }
}

