/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public interface HttpClient
extends AutoCloseable {
    @Override
    public void close();

    public DerivedClientBuilder newBuilder();

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest var1, Class<T> var2);

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytes(HttpRequest var1, AsyncBody.Consumer<List<ByteBuffer>> var2);

    public WebSocket.Builder newWebSocketBuilder();

    public HttpRequest.Builder newHttpRequestBuilder();

    public static interface Builder
    extends DerivedClientBuilder {
        @Override
        public HttpClient build();

        public Builder connectTimeout(long var1, TimeUnit var3);

        @Override
        public Builder addOrReplaceInterceptor(String var1, Interceptor var2);

        @Override
        public Builder authenticatorNone();

        public Builder sslContext(KeyManager[] var1, TrustManager[] var2);

        public Builder followAllRedirects();

        public Builder proxyAddress(InetSocketAddress var1);

        public Builder proxyAuthorization(String var1);

        public Builder tlsVersions(TlsVersion ... var1);

        public Builder preferHttp11();

        public Builder proxyType(ProxyType var1);
    }

    public static interface DerivedClientBuilder {
        public HttpClient build();

        public DerivedClientBuilder addOrReplaceInterceptor(String var1, Interceptor var2);

        public DerivedClientBuilder authenticatorNone();

        public DerivedClientBuilder tag(Object var1);
    }

    public static interface Factory {
        default public Builder newBuilder(Config config) {
            Builder builder = this.newBuilder();
            HttpClientUtils.applyCommonConfiguration(config, builder, this);
            return builder;
        }

        public Builder newBuilder();

        default public int priority() {
            return 0;
        }
    }

    public static enum ProxyType {
        HTTP,
        SOCKS4,
        SOCKS5,
        DIRECT;

    }
}

