/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;

public final class DefaultEndpointThenInvalidateRegion
implements Function<Object, URI> {
    private final Function<Object, URI> delegate;
    private final LoadingCache<String, Optional<String>> bucketToRegionCache;

    @Inject
    DefaultEndpointThenInvalidateRegion(AssignCorrectHostnameForBucket delegate, @Bucket LoadingCache<String, Optional<String>> bucketToRegionCache) {
        this.delegate = delegate;
        this.bucketToRegionCache = bucketToRegionCache;
    }

    public URI apply(@Nullable Object from) {
        try {
            URI uRI = (URI)this.delegate.apply(from);
            return uRI;
        }
        finally {
            this.bucketToRegionCache.invalidate((Object)from.toString());
        }
    }
}

