/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityGroupEditor {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityGroupEditor.class);
    public static final String JCLOUDS_PREFIX_REGEX = "^jclouds[#-]";
    private final Location location;
    private final SecurityGroupExtension securityApi;
    private final Predicate<Exception> isExceptionRetryable;

    public SecurityGroupEditor(Location location, SecurityGroupExtension securityGroupExtension) {
        this.location = (Location)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.securityApi = (SecurityGroupExtension)Preconditions.checkNotNull((Object)securityGroupExtension, (Object)"securityGroupExtension");
        this.isExceptionRetryable = Predicates.alwaysFalse();
    }

    @Deprecated
    public SecurityGroupEditor(Location location, SecurityGroupExtension securityGroupExtension, Predicate<Exception> isExceptionRetryable) {
        this.location = (Location)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.securityApi = (SecurityGroupExtension)Preconditions.checkNotNull((Object)securityGroupExtension, (Object)"securityGroupExtension");
        this.isExceptionRetryable = isExceptionRetryable;
    }

    public Location getLocation() {
        return this.location;
    }

    public Set<SecurityGroup> getSecurityGroupsForNode(String nodeId) {
        return this.securityApi.listSecurityGroupsForNode(nodeId);
    }

    public SecurityGroup createSecurityGroup(final String name) {
        LOG.debug("Creating security group {} in {}", (Object)name, (Object)this.location);
        Callable<SecurityGroup> callable = new Callable<SecurityGroup>(){

            @Override
            public SecurityGroup call() throws Exception {
                return SecurityGroupEditor.this.securityApi.createSecurityGroup(name, SecurityGroupEditor.this.location);
            }

            public String toString() {
                return "Create security group " + name;
            }
        };
        return this.runOperationWithRetry(callable);
    }

    public boolean removeSecurityGroup(SecurityGroup group) {
        LOG.debug("Removing security group {} in {}", (Object)group.getName(), (Object)this.location);
        RemoveSecurityGroup removeIt = new RemoveSecurityGroup(group.getId());
        return this.runOperationWithRetry(removeIt);
    }

    public boolean removeSecurityGroup(String groupId) {
        LOG.debug("Removing security group {} in {}", (Object)groupId, (Object)this.location);
        RemoveSecurityGroup removeIt = new RemoveSecurityGroup(groupId);
        return this.runOperationWithRetry(removeIt);
    }

    public Set<SecurityGroup> listSecurityGroupsForNode(String nodeId) {
        return this.securityApi.listSecurityGroupsForNode(nodeId);
    }

    public Iterable<SecurityGroup> findSecurityGroupsMatching(Predicate predicate) {
        Set locationGroups = this.securityApi.listSecurityGroupsInLocation(this.location);
        return Iterables.filter((Iterable)locationGroups, (Predicate)predicate);
    }

    public Optional<SecurityGroup> findSecurityGroupByName(final String name) {
        Iterable<SecurityGroup> groupsMatching = this.findSecurityGroupsMatching((Predicate)new Predicate<SecurityGroup>(){
            final String rawName;
            {
                this.rawName = name.replaceAll(SecurityGroupEditor.JCLOUDS_PREFIX_REGEX, "");
            }

            public boolean apply(SecurityGroup input) {
                return input.getName().replaceAll(SecurityGroupEditor.JCLOUDS_PREFIX_REGEX, "").equals(this.rawName);
            }
        });
        ImmutableList matches = ImmutableList.copyOf(groupsMatching);
        if (matches.size() == 0) {
            return Optional.absent();
        }
        if (matches.size() == 1) {
            return Optional.of((Object)matches.get(0));
        }
        throw new AmbiguousGroupName("Unexpected result of multiple groups matching " + name);
    }

    public SecurityGroup addPermissions(SecurityGroup group, Iterable<IpPermission> permissions) {
        SecurityGroup lastGroup = group;
        for (IpPermission permission : permissions) {
            lastGroup = this.addPermission(group, permission);
        }
        return lastGroup;
    }

    public SecurityGroup addPermission(final SecurityGroup group, final IpPermission permission) {
        LOG.debug("Adding permission to security group {}: {}", (Object)group.getName(), (Object)permission);
        Callable<SecurityGroup> callable = new Callable<SecurityGroup>(){

            @Override
            public SecurityGroup call() throws Exception {
                try {
                    return SecurityGroupEditor.this.securityApi.addIpPermission(permission, group);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (SecurityGroupEditor.this.isDuplicate(e)) {
                        return group;
                    }
                    throw Exceptions.propagate((Throwable)e);
                }
            }

            public String toString() {
                return "Add permission " + permission + " to security group " + group;
            }
        };
        return this.runOperationWithRetry(callable);
    }

    @Deprecated
    private boolean isDuplicate(Exception e) {
        AWSResponseException cause = (AWSResponseException)Exceptions.getFirstThrowableOfType((Throwable)e, AWSResponseException.class);
        if (cause != null && "InvalidPermission.Duplicate".equals(cause.getError().getCode())) {
            return true;
        }
        return e.toString().contains("already exists");
    }

    public SecurityGroup removePermission(final SecurityGroup group, final IpPermission permission) {
        LOG.debug("Removing permission from security group {}: {}", (Object)group.getName(), (Object)permission);
        Callable<SecurityGroup> callable = new Callable<SecurityGroup>(){

            @Override
            public SecurityGroup call() throws Exception {
                return SecurityGroupEditor.this.securityApi.removeIpPermission(permission, group);
            }

            public String toString() {
                return "Remove permission " + permission + " from security group " + group;
            }
        };
        return this.runOperationWithRetry(callable);
    }

    public SecurityGroup removePermissions(SecurityGroup group, Iterable<IpPermission> permissions) {
        for (IpPermission permission : permissions) {
            group = this.removePermission(group, permission);
        }
        return group;
    }

    protected <T> T runOperationWithRetry(Callable<T> operation) {
        int backoff = 64;
        Exception lastException = null;
        LOG.debug("Running operation {}", operation);
        for (int retries = 0; retries < 12; ++retries) {
            try {
                return operation.call();
            }
            catch (Exception e) {
                lastException = e;
                if (!this.isExceptionRetryable.apply((Object)e)) break;
                LOG.debug("Attempt #{} failed to run operation, due to: {}", (Object)(retries + 1), (Object)e.getMessage());
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException e1) {
                    throw Exceptions.propagate((Throwable)e1);
                }
                backoff <<= 1;
                continue;
            }
        }
        throw new RuntimeException("Unable to run operation '" + operation + "'; repeated errors from provider", lastException);
    }

    public String toString() {
        return "JcloudsLocationSecurityGroupEditor{location=" + this.location + ", securityApi=" + this.securityApi + ", isExceptionRetryable=" + this.isExceptionRetryable + '}';
    }

    private class RemoveSecurityGroup
    implements Callable<Boolean> {
        private String groupId;

        public RemoveSecurityGroup(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public Boolean call() throws Exception {
            return SecurityGroupEditor.this.securityApi.removeSecurityGroup(this.groupId);
        }

        public String toString() {
            return "Remove security group " + this.groupId;
        }
    }

    public static class AmbiguousGroupName
    extends IllegalArgumentException {
        public AmbiguousGroupName(String s) {
            super(s);
        }
    }
}

