/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.entity;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityType;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.guava.Maybe;

public interface Entity
extends BrooklynObject {
    @Override
    public String getId();

    public long getCreationTime();

    @Override
    public String getDisplayName();

    @Deprecated
    @Nullable
    public String getIconUrl();

    public EntityType getEntityType();

    public Application getApplication();

    public String getApplicationId();

    public Entity getParent();

    public Collection<Entity> getChildren();

    public void setDisplayName(String var1);

    public Entity setParent(Entity var1);

    public void clearParent();

    public <T extends Entity> T addChild(T var1);

    public <T extends Entity> T addChild(EntitySpec<T> var1);

    public boolean removeChild(Entity var1);

    public Collection<Location> getLocations();

    public <T> T getAttribute(AttributeSensor<T> var1);

    public <T> T getConfig(ConfigKey.HasConfigKey<T> var1);

    public <T> Task<T> invoke(Effector<T> var1, Map<String, ?> var2);

    @Deprecated
    public <T extends Feed> T addFeed(T var1);

    public SensorSupport sensors();

    public PolicySupport policies();

    public EnricherSupport enrichers();

    public GroupSupport groups();

    public BrooklynObject.RelationSupport<Entity> relations();

    @Beta
    public static interface GroupSupport
    extends Iterable<Group> {
        @Override
        public Iterator<Group> iterator();

        public int size();

        public boolean isEmpty();
    }

    @Beta
    public static interface EnricherSupport
    extends AdjunctSupport<Enricher> {
        @Override
        public void add(Enricher var1);

        @Override
        public boolean remove(Enricher var1);

        public <T extends Enricher> T add(EnricherSpec<T> var1);
    }

    @Beta
    public static interface PolicySupport
    extends AdjunctSupport<Policy> {
        @Override
        public void add(Policy var1);

        @Override
        public boolean remove(Policy var1);

        public <T extends Policy> T add(PolicySpec<T> var1);
    }

    public static interface AdjunctSupport<T extends EntityAdjunct>
    extends Iterable<T> {
        @Override
        public Iterator<T> iterator();

        public int size();

        public boolean isEmpty();

        public List<T> asList();

        public void add(T var1);

        public boolean remove(T var1);
    }

    @Beta
    public static interface SensorSupport {
        public <T> T get(AttributeSensor<T> var1);

        public <T> T set(AttributeSensor<T> var1, T var2);

        @Beta
        public <T> T modify(AttributeSensor<T> var1, Function<? super T, Maybe<T>> var2);

        public <T> void emit(Sensor<T> var1, T var2);

        @Beta
        public Map<AttributeSensor<?>, Object> getAll();
    }
}

