/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.jetty;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.objs.HasShortName;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import org.apache.brooklyn.entity.webapp.jetty.Jetty6ServerImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Jetty6 Server", description="Old version (v6 @ Mortbay) of the popular Jetty webapp container", iconUrl="classpath:///jetty-logo.png")
@ImplementedBy(value=Jetty6ServerImpl.class)
public interface Jetty6Server
extends JavaWebAppSoftwareProcess,
UsesJmx,
HasShortName {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"6.1.26");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"jetty-%s");
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="configXmlTemplateUrl")
    public static final ConfigKey<String> CONFIG_XML_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"jetty.configXml.templateUrl", (String)"Extra XML configuration file template URL if required");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"http://get.jenv.mvnsearch.org/download/jetty/jetty-${version}.zip");
    public static final AttributeSensor<Integer> RESPONSES_4XX_COUNT = Sensors.newIntegerSensor((String)"webapp.responses.4xx", (String)"Responses in the 400's");
    public static final AttributeSensor<Integer> RESPONSES_5XX_COUNT = Sensors.newIntegerSensor((String)"webapp.responses.5xx", (String)"Responses in the 500's");
}

