/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationprofilestatus.build.Maven;
import org.apache.camel.v1.integrationprofilestatus.build.Registry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"baseImage", "maven", "registry", "runtimeProvider", "runtimeVersion", "timeout"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Build
implements KubernetesResource {
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="a base image that can be used as base layer for all images. It can be useful if you want to provide some custom base image with further utility software")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="maven")
    @JsonPropertyDescription(value="Maven configuration used to build the Camel/Camel-Quarkus applications")
    @JsonSetter(nulls=Nulls.SKIP)
    private Maven maven;
    @JsonProperty(value="registry")
    @JsonPropertyDescription(value="the image registry used to push/pull Integration images")
    @JsonSetter(nulls=Nulls.SKIP)
    private Registry registry;
    @JsonProperty(value="runtimeProvider")
    @JsonPropertyDescription(value="the runtime used. Likely Camel Quarkus (we used to have main runtime which has been discontinued since version 1.5)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeProvider;
    @JsonProperty(value="runtimeVersion")
    @JsonPropertyDescription(value="the Camel K Runtime dependency version")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeVersion;
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="how much time to wait before time out the pipeline process")
    @JsonSetter(nulls=Nulls.SKIP)
    private String timeout;

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public Maven getMaven() {
        return this.maven;
    }

    public void setMaven(Maven maven) {
        this.maven = maven;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public void setRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "Build(baseImage=" + this.getBaseImage() + ", maven=" + this.getMaven() + ", registry=" + this.getRegistry() + ", runtimeProvider=" + this.getRuntimeProvider() + ", runtimeVersion=" + this.getRuntimeVersion() + ", timeout=" + this.getTimeout() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Build)) {
            return false;
        }
        Build other = (Build)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        Maven this$maven = this.getMaven();
        Maven other$maven = other.getMaven();
        if (this$maven == null ? other$maven != null : !((Object)this$maven).equals(other$maven)) {
            return false;
        }
        Registry this$registry = this.getRegistry();
        Registry other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry)) {
            return false;
        }
        String this$runtimeProvider = this.getRuntimeProvider();
        String other$runtimeProvider = other.getRuntimeProvider();
        if (this$runtimeProvider == null ? other$runtimeProvider != null : !this$runtimeProvider.equals(other$runtimeProvider)) {
            return false;
        }
        String this$runtimeVersion = this.getRuntimeVersion();
        String other$runtimeVersion = other.getRuntimeVersion();
        if (this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Build;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        Maven $maven = this.getMaven();
        result = result * 59 + ($maven == null ? 43 : ((Object)$maven).hashCode());
        Registry $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        String $runtimeProvider = this.getRuntimeProvider();
        result = result * 59 + ($runtimeProvider == null ? 43 : $runtimeProvider.hashCode());
        String $runtimeVersion = this.getRuntimeVersion();
        result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        return result;
    }
}

