/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.PrintWriter;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ExpressionParserTreeConstants;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ASTScalar
extends SimpleNode {
    protected Object value;

    ASTScalar(int id) {
        super(id);
    }

    public ASTScalar() {
        super(21);
    }

    public ASTScalar(Object value) {
        super(21);
        this.setValue(value);
    }

    protected Object evaluateNode(Object o) throws Exception {
        return this.value;
    }

    public Expression shallowCopy() {
        ASTScalar copy = new ASTScalar(this.id);
        copy.value = this.value;
        return copy;
    }

    public void encodeAsString(PrintWriter pw) {
        SimpleNode.encodeScalarAsString(pw, this.value, '\"');
    }

    public void encodeAsEJBQL(PrintWriter pw, String rootId) {
        Persistent persistent;
        ObjectId id;
        Object scalar = this.value;
        if (scalar instanceof Persistent && !(id = (persistent = (Persistent)scalar).getObjectId()).isTemporary() && id.getIdSnapshot().size() == 1) {
            scalar = id.getIdSnapshot().values().iterator().next();
        }
        SimpleNode.encodeScalarAsString(pw, scalar, '\'');
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    protected String getExpressionOperator(int index) {
        throw new UnsupportedOperationException("No operator for '" + ExpressionParserTreeConstants.jjtNodeName[this.id] + "'");
    }
}

