/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyRelationshipAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfo;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ObjRelationshipTableModel;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjEntityRelationshipTab
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjRelationshipListener,
ExistingSelectionProcessor {
    private static Log logObj = LogFactory.getLog(ObjEntityRelationshipTab.class);
    private static final Object[] deleteRules = new Object[]{DeleteRule.deleteRuleName(0), DeleteRule.deleteRuleName(1), DeleteRule.deleteRuleName(2), DeleteRule.deleteRuleName(3)};
    ProjectController mediator;
    CayenneTable table;
    private TableColumnPreferences tablePreferences;
    JButton resolve;
    protected JMenuItem resolveMenu;

    public ObjEntityRelationshipTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateRelationshipAction.class).buildButton());
        toolBar.add(actionManager.getAction(ObjEntitySyncAction.class).buildButton());
        toolBar.addSeparator();
        ImageIcon ico = ModelerUtil.buildIcon("icon-info.gif");
        this.resolve = new JButton();
        this.resolve.setIcon(ico);
        this.resolve.setToolTipText("Edit Relationship");
        toolBar.add(this.resolve);
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(RemoveRelationshipAction.class).buildButton());
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(CutRelationshipAction.class).buildButton());
        toolBar.add(actionManager.getAction(CopyRelationshipAction.class).buildButton());
        toolBar.add(actionManager.getAction(PasteAction.class).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new StringRenderer());
        this.table.setDefaultRenderer(ObjEntity.class, new EntityRenderer());
        this.tablePreferences = new TableColumnPreferences(ObjRelationshipTableModel.class, "objEntity/relationshipTable");
        this.resolveMenu = new JMenuItem("Database Mapping", ico);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.resolveMenu);
        popup.add(actionManager.getAction(RemoveRelationshipAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjRelationshipListener(this);
        ActionListener resolver = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ObjEntityRelationshipTab.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                ObjRelationshipTableModel model = (ObjRelationshipTableModel)ObjEntityRelationshipTab.this.table.getModel();
                new ObjRelationshipInfo(ObjEntityRelationshipTab.this.mediator, model.getRelationship(row)).startupAction();
                ObjEntityRelationshipTab.this.table.cancelEditing();
                ObjEntityRelationshipTab.this.table.getSelectionModel().clearSelection();
                ObjEntityRelationshipTab.this.table.select(row);
            }
        };
        this.resolve.addActionListener(resolver);
        this.resolveMenu.addActionListener(resolver);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ObjEntityRelationshipTab.this.processExistingSelection(e);
            }
        });
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutRelationshipAction.class, CopyRelationshipAction.class);
    }

    public void selectRelationships(ObjRelationship[] rels) {
        ModelerUtil.updateActions(rels.length, RemoveRelationshipAction.class, CutRelationshipAction.class, CopyRelationshipAction.class);
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[rels.length];
        for (int i = 0; i < rels.length; ++i) {
            newSel[i] = listAttrs.indexOf(rels[i]);
        }
        this.table.select(newSel);
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        Relationship[] rels = new ObjRelationship[]{};
        if (this.table.getSelectedRow() >= 0) {
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            rels = new ObjRelationship[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                rels[i] = model.getRelationship(sel[i]);
            }
            this.resolve.setEnabled(true);
            UIUtil.scrollToSelectedRow(this.table);
        } else {
            this.resolve.setEnabled(false);
        }
        this.resolveMenu.setEnabled(this.resolve.isEnabled());
        RelationshipDisplayEvent ev = new RelationshipDisplayEvent((Object)this, rels, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
        this.mediator.fireObjRelationshipDisplayEvent(ev);
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    private Object[] createObjEntityComboModel() {
        DataMap map = this.mediator.getCurrentDataMap();
        if (map == null) {
            logObj.warn("createObjEntityComboModel:: Null DataMap.");
            return new Object[0];
        }
        if (map.getNamespace() == null) {
            logObj.warn("createObjEntityComboModel:: Null DataMap namespace - " + map);
            return new Object[0];
        }
        Collection<ObjEntity> objEntities = map.getNamespace().getObjEntities();
        return objEntities.toArray();
    }

    public void objEntityChanged(EntityEvent e) {
    }

    public void objEntityAdded(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void objEntityRemoved(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void objRelationshipChanged(RelationshipEvent e) {
        this.table.select(e.getRelationship());
    }

    public void objRelationshipAdded(RelationshipEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getRelationship());
    }

    public void objRelationshipRemoved(RelationshipEvent e) {
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getRelationship());
        model.removeRow(e.getRelationship());
        this.table.select(ind);
    }

    private void reloadEntityList(EntityEvent e) {
        if (e.getSource() != this) {
            return;
        }
        ObjEntity entity = this.mediator.getCurrentObjEntity();
        if (entity == e.getEntity() || entity == null) {
            return;
        }
        TableColumn col = this.table.getColumnModel().getColumn(1);
        DefaultCellEditor editor = (DefaultCellEditor)col.getCellEditor();
        JComboBox combo = (JComboBox)editor.getComponent();
        combo.setRenderer(CellRenderers.entityListRendererWithIcons(entity.getDataMap()));
        combo.setModel(new DefaultComboBoxModel<Object>(this.createObjEntityComboModel()));
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        model.fireTableDataChanged();
    }

    protected void rebuildTable(ObjEntity entity) {
        final ObjRelationshipTableModel model = new ObjRelationshipTableModel(entity, this.mediator, this);
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (ObjEntityRelationshipTab.this.table.getSelectedRow() >= 0) {
                    ObjRelationship rel = model.getRelationship(ObjEntityRelationshipTab.this.table.getSelectedRow());
                    if (((ObjEntity)rel.getSourceEntity()).getDbEntity() != null) {
                        ObjEntityRelationshipTab.this.resolve.setEnabled(true);
                    } else {
                        ObjEntityRelationshipTab.this.resolve.setEnabled(false);
                    }
                    ObjEntityRelationshipTab.this.resolveMenu.setEnabled(ObjEntityRelationshipTab.this.resolve.isEnabled());
                }
            }
        });
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn col = this.table.getColumnModel().getColumn(1);
        JComboBox targetCombo = Application.getWidgetFactory().createComboBox(this.createObjEntityComboModel(), false);
        AutoCompletion.enable(targetCombo);
        targetCombo.setRenderer(CellRenderers.entityListRendererWithIcons(entity.getDataMap()));
        targetCombo.setSelectedIndex(-1);
        col.setCellEditor(Application.getWidgetFactory().createCellEditor(targetCombo));
        col = this.table.getColumnModel().getColumn(3);
        JComboBox deleteRulesCombo = Application.getWidgetFactory().createComboBox(deleteRules, false);
        deleteRulesCombo.setEditable(false);
        deleteRulesCombo.setSelectedIndex(0);
        col.setCellEditor(Application.getWidgetFactory().createCellEditor(deleteRulesCombo));
        this.tablePreferences.bind(this.table, null, null, null, 0, true);
    }

    class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int align = column == 2 ? 0 : 2;
            super.setHorizontalAlignment(align);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)table.getModel();
            ObjRelationship relationship = model.getRelationship(row);
            if (relationship != null && relationship.getSourceEntity() != model.getEntity()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            return this;
        }
    }

    class EntityRenderer
    extends StringRenderer {
        EntityRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object oldValue = value;
            value = CellRenderers.asString(value);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(CellRenderers.iconForObject(oldValue));
            return this;
        }
    }
}

