/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import org.apache.cayenne.pref.CayennePreference;

public class FSPath
extends CayennePreference {
    public static final String PATH_PROPERTY = "path";

    public FSPath(Preferences preferences) {
        this.setCurrentPreference(preferences);
    }

    public void updateFromChooser(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        if (file != null) {
            this.setDirectory(file);
        }
    }

    public void updateChooser(JFileChooser chooser) {
        File startDir = this.getExistingDirectory(false);
        if (startDir != null) {
            chooser.setCurrentDirectory(startDir);
        }
    }

    public void setDirectory(File file) {
        if (file.isFile()) {
            this.setPath(file.getParentFile().getAbsolutePath());
        } else {
            this.setPath(file.getAbsolutePath());
        }
    }

    public File getExistingDirectory(boolean create) {
        if (this.getPath() == null) {
            return null;
        }
        File path = new File(this.getPath());
        if (path.isDirectory()) {
            return path;
        }
        if (path.isFile()) {
            return path.getParentFile();
        }
        if (create) {
            path.mkdirs();
            return path;
        }
        return null;
    }

    public void setPath(String path) {
        this.getCurrentPreference().put(PATH_PROPERTY, path);
    }

    public String getPath() {
        return this.getCurrentPreference().get(PATH_PROPERTY, null);
    }

    public String getKey() {
        return this.getCurrentPreference().name();
    }
}

