/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.util.Collection;
import java.util.Objects;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;

public abstract class CayenneRuntime {
    protected static final ThreadLocal<Injector> threadInjector = new ThreadLocal();
    protected Injector injector;
    protected Collection<Module> modules;

    public static void bindThreadInjector(Injector injector) {
        threadInjector.set(injector);
    }

    public static Injector getThreadInjector() {
        return threadInjector.get();
    }

    protected CayenneRuntime(Collection<Module> modules) {
        this.modules = Objects.requireNonNull(modules);
        this.injector = DIBootstrap.createInjector(modules);
    }

    public Collection<Module> getModules() {
        return this.modules;
    }

    public Injector getInjector() {
        return this.injector;
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.injector.shutdown();
    }

    public DataChannel getChannel() {
        return this.injector.getInstance(DataChannel.class);
    }

    public ObjectContext newContext() {
        return this.injector.getInstance(ObjectContextFactory.class).createContext();
    }

    public ObjectContext newContext(DataChannel parentChannel) {
        return this.injector.getInstance(ObjectContextFactory.class).createContext(parentChannel);
    }

    @Deprecated
    public ObjectContext getContext() {
        return this.newContext();
    }

    @Deprecated
    public ObjectContext getContext(DataChannel parentChannel) {
        return this.newContext(parentChannel);
    }
}

