/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import java.util.Objects;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.dbsync.naming.NameUtil;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;

class DeduplicationVisitor
implements ConfigurationNodeVisitor<String> {
    private ConfigurationNode parent;
    private String baseName;
    private String dupesPattern;

    DeduplicationVisitor(ConfigurationNode parent, String baseName, String dupesPattern) {
        this.parent = parent;
        this.baseName = Objects.requireNonNull(baseName);
        this.dupesPattern = Objects.requireNonNull(dupesPattern);
    }

    @Override
    public String visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
        return this.baseName;
    }

    @Override
    public String visitDataNodeDescriptor(DataNodeDescriptor nodeDescriptor) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)DeduplicationVisitor.this.parent;
                for (DataNodeDescriptor dataNodeDescriptor : dataChannelDescriptor.getNodeDescriptors()) {
                    if (!dataNodeDescriptor.getName().equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public String visitDataMap(DataMap dataMap) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                if (DeduplicationVisitor.this.parent == null) {
                    return false;
                }
                if (DeduplicationVisitor.this.parent instanceof DataChannelDescriptor) {
                    DataChannelDescriptor domain = (DataChannelDescriptor)DeduplicationVisitor.this.parent;
                    return domain.getDataMap(name) != null;
                }
                return false;
            }
        });
    }

    @Override
    public String visitObjEntity(ObjEntity entity) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                DataMap map = (DataMap)DeduplicationVisitor.this.parent;
                return map.getObjEntity(name) != null;
            }
        });
    }

    @Override
    public String visitDbEntity(DbEntity entity) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                DataMap map = (DataMap)DeduplicationVisitor.this.parent;
                return map.getDbEntity(name) != null;
            }
        });
    }

    @Override
    public String visitEmbeddable(Embeddable embeddable) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                DataMap map = (DataMap)DeduplicationVisitor.this.parent;
                return map.getEmbeddable(map.getNameWithDefaultPackage(name)) != null;
            }
        });
    }

    @Override
    public String visitEmbeddableAttribute(EmbeddableAttribute attribute) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                Embeddable emb = (Embeddable)DeduplicationVisitor.this.parent;
                return emb.getAttribute(name) != null;
            }
        });
    }

    @Override
    public String visitObjAttribute(ObjAttribute attribute) {
        return this.resolveObjEntityProperty();
    }

    @Override
    public String visitDbAttribute(DbAttribute attribute) {
        return this.resolveDbEntityProperty();
    }

    @Override
    public String visitObjRelationship(ObjRelationship relationship) {
        return this.resolveObjEntityProperty();
    }

    @Override
    public String visitDbRelationship(DbRelationship relationship) {
        return this.resolveDbEntityProperty();
    }

    @Override
    public String visitProcedure(Procedure procedure) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                DataMap map = (DataMap)DeduplicationVisitor.this.parent;
                return map.getProcedure(name) != null;
            }
        });
    }

    @Override
    public String visitProcedureParameter(ProcedureParameter parameter) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                Procedure procedure = (Procedure)DeduplicationVisitor.this.parent;
                for (ProcedureParameter parameter : procedure.getCallParameters()) {
                    if (!name.equals(parameter.getName())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public String visitQuery(QueryDescriptor query) {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                DataMap map = (DataMap)DeduplicationVisitor.this.parent;
                return map.getQueryDescriptor(name) != null;
            }
        });
    }

    String resolve(Predicate nameChecker) {
        int c = 1;
        String name = this.baseName;
        while (nameChecker.isNameInUse(name)) {
            name = String.format(this.dupesPattern, this.baseName, c++);
        }
        return name;
    }

    private String resolveDbEntityProperty() {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                DbEntity entity = (DbEntity)DeduplicationVisitor.this.parent;
                return entity.getAttribute(name) != null || entity.getRelationship(name) != null;
            }
        });
    }

    private String resolveObjEntityProperty() {
        return this.resolve(new Predicate(){

            @Override
            public boolean isNameInUse(String name) {
                ObjEntity entity = (ObjEntity)DeduplicationVisitor.this.parent;
                if (entity.getAttribute(name) != null || entity.getRelationship(name) != null) {
                    return true;
                }
                String conflictingCallback = "get" + NameUtil.capitalize(name);
                return entity.getCallbackMethods().contains(conflictingCallback);
            }
        });
    }

    static interface Predicate {
        public boolean isNameInUse(String var1);
    }
}

