/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbload.AbstractLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.map.DbEntity;

public abstract class PerEntityLoader
extends AbstractLoader {
    PerEntityLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
    }

    @Override
    public void load(DatabaseMetaData metaData, DbLoadDataStore map) throws SQLException {
        for (DbEntity dbEntity : map.getDbEntities()) {
            if (!this.shouldLoad(dbEntity)) continue;
            try {
                ResultSet rs = this.getResultSet(dbEntity, metaData);
                Throwable throwable = null;
                try {
                    while (rs.next()) {
                        this.processResultSet(dbEntity, map, rs);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (SQLException ex) {
                if (this.catchException(dbEntity, ex)) continue;
                throw ex;
            }
        }
    }

    boolean shouldLoad(DbEntity entity) {
        return true;
    }

    boolean catchException(DbEntity entity, SQLException ex) {
        return false;
    }

    abstract ResultSet getResultSet(DbEntity var1, DatabaseMetaData var2) throws SQLException;

    abstract void processResultSet(DbEntity var1, DbLoadDataStore var2, ResultSet var3) throws SQLException;
}

