/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.RedoAction;
import org.apache.cayenne.modeler.action.UndoAction;
import org.apache.cayenne.modeler.undo.TextCompoundEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CayenneUndoManager
extends UndoManager {
    private Application application;

    public CayenneUndoManager(Application application) {
        this.application = application;
        this.setLimit(100);
    }

    @Override
    public void discardAllEdits() {
        super.discardAllEdits();
        this.updateUI();
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        boolean result = super.addEdit(anEdit);
        this.updateUI();
        return result;
    }

    @Override
    public void redo() throws CannotRedoException {
        UndoableEdit e = this.editToBeRedone();
        if (e instanceof TextCompoundEdit) {
            TextCompoundEdit edit = (TextCompoundEdit)e;
            edit.watchCaretPosition();
            super.redo();
            edit.stopWatchingCaretPosition();
        } else {
            super.redo();
        }
        this.updateUI();
    }

    @Override
    public void undo() throws CannotUndoException {
        UndoableEdit e = this.editToBeUndone();
        if (e instanceof TextCompoundEdit) {
            TextCompoundEdit edit = (TextCompoundEdit)e;
            edit.watchCaretPosition();
            super.undo();
            edit.stopWatchingCaretPosition();
        } else {
            super.undo();
        }
        this.updateUI();
    }

    private void updateUI() {
        CayenneAction undoAction = this.application.getActionManager().getAction(UndoAction.class);
        CayenneAction redoAction = this.application.getActionManager().getAction(RedoAction.class);
        undoAction.setEnabled(this.canUndo());
        redoAction.setEnabled(this.canRedo());
        undoAction.setName(this.getUndoPresentationName());
        redoAction.setName(this.getRedoPresentationName());
    }
}

