/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateObjEntityUndoableEdit
extends CayenneUndoableEdit {
    private DataMap map;
    private ObjEntity objEntity;

    public CreateObjEntityUndoableEdit(DataMap map, ObjEntity objEntity) {
        this.map = map;
        this.objEntity = objEntity;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Create ObjEntity";
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateObjEntityAction action = this.actionManager.getAction(CreateObjEntityAction.class);
        action.createObjEntity(this.map, this.objEntity);
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveAction action = this.actionManager.getAction(RemoveAction.class);
        action.removeObjEntity(this.map, this.objEntity);
    }
}

