/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.undo.TextCompoundEdit;
import org.apache.cayenne.modeler.util.TextAdapter;

public class JTextFieldUndoListener
implements UndoableEditListener {
    public CompoundEdit compoundEdit;
    private TextAdapter adapter;
    private JTextComponent editor;
    private int lastOffset;
    private int lastLength;

    public JTextFieldUndoListener(TextAdapter adapter) {
        this(adapter.getComponent());
        this.adapter = adapter;
    }

    public JTextFieldUndoListener(JTextComponent editor) {
        this.editor = editor;
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextFieldUndoListener.this.finishCurrentEdit();
            }
        });
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEdit == null || !this.compoundEdit.canUndo()) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            this.lastLength = this.editor.getDocument().getLength();
            return;
        }
        if ("AbstractDocument.styleChangeText".equals(e.getEdit().getPresentationName())) {
            this.compoundEdit.addEdit(e.getEdit());
            return;
        }
        int offsetChange = this.editor.getCaretPosition() - this.lastOffset;
        int lengthChange = this.editor.getDocument().getLength() - this.lastLength;
        if (Math.abs(offsetChange) == 1 && Math.abs(lengthChange) == 1) {
            this.compoundEdit.addEdit(e.getEdit());
            this.lastOffset = this.editor.getCaretPosition();
            this.lastLength = this.editor.getDocument().getLength();
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        this.lastLength = this.editor.getDocument().getLength();
        this.compoundEdit = this.adapter != null ? new TextCompoundEdit(this.adapter, this) : new TextCompoundEdit(this.editor, this);
        this.compoundEdit.addEdit(anEdit);
        Application.getInstance().getUndoManager().addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public void finishCurrentEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.compoundEdit = null;
        }
    }
}

