/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.resource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.resource.URLResource;

public class ClassLoaderResourceLocator
implements ResourceLocator {
    private ClassLoaderManager classLoaderManager;

    public ClassLoaderResourceLocator(@Inject ClassLoaderManager classLoaderManager) {
        this.classLoaderManager = classLoaderManager;
    }

    @Override
    public Collection<Resource> findResources(String name) {
        Enumeration<URL> urls;
        ArrayList<Resource> resources = new ArrayList<Resource>(3);
        try {
            urls = this.classLoaderManager.getClassLoader(name).getResources(name);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error getting resources for ", new Object[0]);
        }
        while (urls.hasMoreElements()) {
            resources.add(new URLResource(urls.nextElement()));
        }
        return resources;
    }

    @Deprecated
    protected ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (loader == null) {
            throw new IllegalStateException("Can't detect ClassLoader to use for resource location");
        }
        return loader;
    }
}

