/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DbAttributeValidator
extends ConfigurationNodeValidator {
    DbAttributeValidator() {
    }

    void validate(DbAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString((String)attribute.getName())) {
            this.addFailure(validationResult, attribute, "Unnamed DbAttribute", new Object[0]);
        } else {
            NameValidationHelper helper = NameValidationHelper.getInstance();
            String invalidChars = helper.invalidCharsInDbPathComponent(attribute.getName());
            if (invalidChars != null) {
                this.addFailure(validationResult, attribute, "DbAttribute name '%s' contains invalid characters: %s", attribute.getName(), invalidChars);
            }
        }
        if (attribute.getType() == Integer.MAX_VALUE) {
            this.addFailure(validationResult, attribute, "DbAttribute has no type", new Object[0]);
        } else if (attribute.getMaxLength() < 0 && (attribute.getType() == 12 || attribute.getType() == -9 || attribute.getType() == 1 || attribute.getType() == -15)) {
            this.addFailure(validationResult, attribute, "Character DbAttribute '%s' doesn't have max length", attribute.getName());
        }
    }
}

