/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.sql.Connection;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.hsqldb.HSQLDBProcedureTranslator;
import org.apache.cayenne.dba.hsqldb.HSQLSelectAction;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;

class HSQLActionBuilder
extends JdbcActionBuilder {
    HSQLActionBuilder(DataNode dataNode) {
        super(dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new HSQLSelectAction(query, this.dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(FluentSelect<T> query) {
        return new HSQLSelectAction(query, this.dataNode);
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new ProcedureAction(query, this.dataNode){

            @Override
            protected ProcedureTranslator createTranslator(Connection connection) {
                HSQLDBProcedureTranslator transl = new HSQLDBProcedureTranslator();
                transl.setAdapter(this.dataNode.getAdapter());
                transl.setQuery(this.query);
                transl.setEntityResolver(this.dataNode.getEntityResolver());
                transl.setConnection(connection);
                transl.setJdbcEventLogger(this.dataNode.getJdbcEventLogger());
                return transl;
            }
        };
    }
}

