/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.DigraphIteration;

public class DepthFirstSearch<E>
implements Iterator<E> {
    protected DigraphIteration<E, ?> factory;
    protected E firstVertex;
    protected ArrayDeque<ArcIterator<E, ?>> stack = new ArrayDeque();
    protected Set<E> seen = new HashSet();

    public DepthFirstSearch(DigraphIteration<E, ?> factory, E firstVertex) {
        this.factory = factory;
        this.firstVertex = firstVertex;
        this.stack.push(factory.outgoingIterator(firstVertex));
        this.seen.add(firstVertex);
    }

    public void reset(E newFirstVertex) {
        this.stack.clear();
        this.seen.clear();
        this.firstVertex = newFirstVertex;
        this.stack.push(this.factory.outgoingIterator(this.firstVertex));
        this.seen.add(this.firstVertex);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public E next() {
        ArcIterator<E, ?> i = this.stack.pop();
        E origin = i.getOrigin();
        while (i.hasNext()) {
            i.next();
            E dst = i.getDestination();
            if (!this.seen.add(dst)) continue;
            this.stack.push(this.factory.outgoingIterator(dst));
        }
        return origin;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method remove() not supported.");
    }
}

