/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import java.util.function.Supplier;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;

public abstract class BaseBuilder
implements NodeBuilder {
    protected final Node root;
    protected final Node[] nodes;

    public BaseBuilder(Node root, int size) {
        this.root = root;
        this.nodes = new Node[size];
    }

    protected Node node(int idx, Supplier<Node> nodeSupplier) {
        if (this.nodes[idx] == null) {
            this.nodes[idx] = nodeSupplier.get();
        }
        return this.nodes[idx];
    }

    @Override
    public Node build() {
        for (Node next : this.nodes) {
            if (next == null) continue;
            this.root.addChild(next);
        }
        return this.root;
    }

    public Node getRoot() {
        return this.root;
    }
}

