/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.template.Context;
import org.apache.cayenne.template.TemplateContextFactory;
import org.apache.cayenne.template.TemplateParserPool;
import org.apache.cayenne.template.parser.Node;
import org.apache.cayenne.template.parser.ParseException;
import org.apache.cayenne.template.parser.SQLTemplateParser;
import org.apache.cayenne.template.parser.TokenMgrError;
import org.apache.cayenne.util.concurrentlinkedhashmap.ConcurrentLinkedHashMap;

public class CayenneSQLTemplateProcessor
implements SQLTemplateProcessor {
    ConcurrentLinkedHashMap<String, Node> templateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(100).build();
    TemplateParserPool parserPool = new TemplateParserPool();
    private TemplateContextFactory contextFactory;

    public CayenneSQLTemplateProcessor(@Inject TemplateContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public SQLStatement processTemplate(String template, Map<String, ?> parameters) {
        Context context = this.contextFactory.createContext(parameters);
        return this.process(template, context);
    }

    @Override
    public SQLStatement processTemplate(String template, List<Object> positionalParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        int i = 0;
        for (Object param : positionalParameters) {
            parameters.put(String.valueOf(i++), param);
        }
        Context context = this.contextFactory.createContext(parameters, true);
        return this.process(template, context);
    }

    protected SQLStatement process(String template, Context context) {
        Node node = this.templateCache.get(template);
        if (node == null) {
            SQLTemplateParser parser = this.parserPool.get();
            try {
                parser.ReInit(new ByteArrayInputStream(template.getBytes()));
                node = parser.template();
            }
            catch (ParseException | TokenMgrError ex) {
                throw new CayenneRuntimeException("Error parsing template '%s' : %s", template, ex.getMessage());
            }
            finally {
                this.parserPool.put(parser);
            }
            this.templateCache.put(template, node);
        }
        node.evaluate(context);
        return new SQLStatement(context.buildTemplate(), context.getColumnDescriptors(), context.getParameterBindings());
    }
}

