/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;
import org.apache.cayenne.exp.property.RelationshipProperty;

public class MapProperty<K, V extends Persistent>
extends BaseProperty<Map<K, V>>
implements RelationshipProperty<Map<K, V>> {
    protected Class<K> keyType;
    protected Class<V> entityType;

    protected MapProperty(CayennePath path, Expression expression, Class<K> keyType, Class<V> entityType) {
        super(path, expression, Map.class);
        this.keyType = keyType;
        this.entityType = entityType;
    }

    public EntityProperty<V> flat() {
        return PropertyFactory.createEntity(ExpressionFactory.fullObjectExp(this.getExpression()), this.getEntityType());
    }

    public Expression contains(V value) {
        return ExpressionFactory.matchExp(this.getExpression(), value);
    }

    public Expression notContains(V value) {
        return ExpressionFactory.noMatchExp(this.getExpression(), value);
    }

    @Deprecated(since="5.0", forRemoval=true)
    @SafeVarargs
    public final Expression contains(V firstValue, V ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    @SafeVarargs
    public final Expression containsValues(V ... values) {
        return ExpressionFactory.inExp(this.getExpression(), (Object[])values);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression contains(Collection<V> values) {
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression containsValuesCollection(Collection<V> values) {
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression notContains(Collection<V> values) {
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression notContainsValuesCollection(Collection<V> values) {
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    @Deprecated(since="5.0", forRemoval=true)
    @SafeVarargs
    public final Expression notContains(V firstValue, V ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    @SafeVarargs
    public final Expression notContainsValues(V ... values) {
        return ExpressionFactory.notInExp(this.getExpression(), (Object[])values);
    }

    public Expression containsId(Object id) {
        return ExpressionFactory.matchExp(this.getExpression(), id);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression containsId(Object firstId, Object ... moreId) {
        int moreValuesLength = moreId != null ? moreId.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstId;
        if (moreValuesLength > 0) {
            System.arraycopy(moreId, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression containsIds(Object ... ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression containsId(Collection<Object> ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression containsIdsCollection(Collection<?> ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression notContainsId(Object id) {
        return ExpressionFactory.noMatchExp(this.getExpression(), id);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression notContainsId(Object firstId, Object ... moreId) {
        int moreValuesLength = moreId != null ? moreId.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstId;
        if (moreValuesLength > 0) {
            System.arraycopy(moreId, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression notContainsIds(Object ... ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public Expression notContainsId(Collection<Object> ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    public Expression notContainsIdsCollection(Collection<?> ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    public MapProperty<K, V> alias(String alias) {
        ASTPath exp = PropertyUtils.createPathExp(this.getPath(), alias, this.getExpression().getPathAliases());
        return PropertyFactory.createMap(exp.getPath(), (Expression)exp, this.getKeyType(), this.getEntityType());
    }

    public MapProperty<K, V> outer() {
        CayennePathSegment last = this.getPath().last();
        if (last.isOuterJoin()) {
            return this;
        }
        CayennePath outerPath = this.getPath().parent().dot(last.outer());
        return PropertyFactory.createMap(outerPath, this.getKeyType(), this.getEntityType());
    }

    protected Class<K> getKeyType() {
        return this.keyType;
    }

    protected Class<V> getEntityType() {
        return this.entityType;
    }

    public MapProperty<K, V> enclosing() {
        return PropertyFactory.createMap(CayennePath.EMPTY_PATH, ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getKeyType(), this.getEntityType());
    }
}

