/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;
import org.apache.cayenne.util.CayenneMapEntry;

public class SelectQueryOrderingTab
extends JPanel
implements PropertyChangeListener {
    private static final String SPLIT_DIVIDER_LOCATION_PROPERTY = "query.orderings.divider.location";
    static final Dimension BROWSER_CELL_DIM = new Dimension(150, 100);
    static final Dimension TABLE_DIM = new Dimension(460, 60);
    static final String PATH_HEADER = "Path";
    static final String ASCENDING_HEADER = "Ascending";
    static final String IGNORE_CASE_HEADER = "Ignore Case";
    static final String REAL_PANEL = "real";
    static final String PLACEHOLDER_PANEL = "placeholder";
    protected ProjectController mediator;
    protected SelectQueryDescriptor selectQuery;
    protected MultiColumnBrowser browser;
    protected JTable table;
    protected CardLayout cardLayout;
    protected JPanel messagePanel;

    public SelectQueryOrderingTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    protected void initView() {
        this.messagePanel = new JPanel(new BorderLayout());
        this.cardLayout = new CardLayout();
        Preferences detail = Application.getInstance().getPreferencesNode(this.getClass(), "");
        int defLocation = Application.getFrame().getHeight() / 2;
        int location = detail != null ? detail.getInt(this.getDividerLocationProperty(), defLocation) : defLocation;
        JSplitPane mainPanel = new JSplitPane(0);
        mainPanel.addPropertyChangeListener("dividerLocation", this);
        mainPanel.setDividerLocation(location);
        mainPanel.setTopComponent(this.createEditorPanel());
        mainPanel.setBottomComponent(this.createSelectorPanel());
        this.setLayout(this.cardLayout);
        this.add((Component)mainPanel, REAL_PANEL);
        this.add((Component)this.messagePanel, PLACEHOLDER_PANEL);
    }

    protected void initController() {
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                UIUtil.scrollToSelectedRow(this.table);
            }
        });
    }

    protected void initFromModel() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        if (query == null || !"SelectQuery".equals(query.getType())) {
            this.processInvalidModel("Unknown query.");
            return;
        }
        if (!(query.getRoot() instanceof Entity)) {
            this.processInvalidModel("SelectQuery has no root set.");
            return;
        }
        this.selectQuery = (SelectQueryDescriptor)query;
        this.browser.setModel(this.createBrowserModel((Entity)this.selectQuery.getRoot()));
        this.table.setModel(this.createTableModel());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.cardLayout.show(this, REAL_PANEL);
    }

    protected void processInvalidModel(String message) {
        JLabel messageLabel = new JLabel(message, 0);
        this.messagePanel.removeAll();
        this.messagePanel.add((Component)messageLabel, "Center");
        this.cardLayout.show(this, PLACEHOLDER_PANEL);
    }

    protected JPanel createEditorPanel() {
        this.table = new JTable();
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.table.setPreferredScrollableViewportSize(TABLE_DIM);
        this.table.setSelectionMode(0);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.table), "Center");
        return panel;
    }

    protected JPanel createSelectorPanel() {
        this.browser = new MultiColumnBrowser();
        this.browser.setPreferredColumnSize(BROWSER_CELL_DIM);
        this.browser.setDefaultRenderer();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createToolbar(), "North");
        panel.add((Component)new JScrollPane(this.browser, 21, 30), "Center");
        panel.setMinimumSize(panel.getPreferredSize());
        return panel;
    }

    protected JComponent createToolbar() {
        CayenneAction.CayenneToolbarButton add = new CayenneAction.CayenneToolbarButton(null, 1);
        ((AbstractButton)add).setText("Add Ordering");
        ImageIcon addIcon = ModelerUtil.buildIcon("icon-plus.png");
        add.setIcon(addIcon);
        add.setDisabledIcon(FilteredIconFactory.createDisabledIcon(addIcon));
        add.addActionListener(e -> this.addOrdering());
        CayenneAction.CayenneToolbarButton remove = new CayenneAction.CayenneToolbarButton(null, 3);
        ((AbstractButton)remove).setText("Remove Ordering");
        ImageIcon removeIcon = ModelerUtil.buildIcon("icon-trash.png");
        remove.setIcon(removeIcon);
        remove.setDisabledIcon(FilteredIconFactory.createDisabledIcon(removeIcon));
        remove.addActionListener(e -> this.removeOrdering());
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createEmptyBorder());
        toolBar.setFloatable(false);
        toolBar.add(add);
        toolBar.add(remove);
        return toolBar;
    }

    protected TreeModel createBrowserModel(Entity<?, ?, ?> entity) {
        return new EntityTreeModel(entity);
    }

    protected TableModel createTableModel() {
        return new OrderingModel();
    }

    protected String getSelectedPath() {
        Object[] path = this.browser.getSelectionPath().getPath();
        if (path.length < 2) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        CayenneMapEntry first = (CayenneMapEntry)path[1];
        buffer.append(first.getName());
        for (int i = 2; i < path.length; ++i) {
            CayenneMapEntry pathEntry = (CayenneMapEntry)path[i];
            buffer.append(".").append(pathEntry.getName());
        }
        return buffer.toString();
    }

    void addOrdering() {
        String orderingPath = this.getSelectedPath();
        if (orderingPath == null) {
            return;
        }
        for (Ordering ord : this.selectQuery.getOrderings()) {
            if (!orderingPath.equals(ord.getSortSpecString())) continue;
            return;
        }
        this.selectQuery.addOrdering(new Ordering(orderingPath, SortOrder.ASCENDING));
        int index = this.selectQuery.getOrderings().size() - 1;
        OrderingModel model = (OrderingModel)this.table.getModel();
        model.fireTableRowsInserted(index, index);
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.selectQuery));
    }

    void removeOrdering() {
        int selection = this.table.getSelectedRow();
        if (selection < 0) {
            return;
        }
        OrderingModel model = (OrderingModel)this.table.getModel();
        Ordering ordering = model.getOrdering(selection);
        this.selectQuery.removeOrdering(ordering);
        model.fireTableRowsDeleted(selection, selection);
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.selectQuery));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("dividerLocation".equals(evt.getPropertyName())) {
            int value = (Integer)evt.getNewValue();
            Preferences detail = Application.getInstance().getPreferencesNode(this.getClass(), "");
            detail.putInt(this.getDividerLocationProperty(), value);
        }
    }

    protected String getDividerLocationProperty() {
        return SPLIT_DIVIDER_LOCATION_PROPERTY;
    }

    final class OrderingModel
    extends AbstractTableModel {
        OrderingModel() {
        }

        Ordering getOrdering(int row) {
            return SelectQueryOrderingTab.this.selectQuery.getOrderings().get(row);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SelectQueryOrderingTab.this.selectQuery != null ? SelectQueryOrderingTab.this.selectQuery.getOrderings().size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Ordering ordering = this.getOrdering(row);
            switch (column) {
                case 0: {
                    return ordering.getSortSpecString();
                }
                case 1: {
                    return ordering.isAscending() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return ordering.isCaseInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: 
                case 2: {
                    return Boolean.class;
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return SelectQueryOrderingTab.PATH_HEADER;
                }
                case 1: {
                    return SelectQueryOrderingTab.ASCENDING_HEADER;
                }
                case 2: {
                    return SelectQueryOrderingTab.IGNORE_CASE_HEADER;
                }
            }
            throw new IndexOutOfBoundsException("Invalid column: " + column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 || column == 2;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Ordering ordering = this.getOrdering(row);
            switch (column) {
                case 1: {
                    if (((Boolean)value).booleanValue()) {
                        ordering.setAscending();
                        break;
                    }
                    ordering.setDescending();
                    break;
                }
                case 2: {
                    if (((Boolean)value).booleanValue()) {
                        ordering.setCaseInsensitive();
                        break;
                    }
                    ordering.setCaseSensitive();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("Invalid editable column: " + column);
                }
            }
            SelectQueryOrderingTab.this.mediator.fireQueryEvent(new QueryEvent((Object)SelectQueryOrderingTab.this, SelectQueryOrderingTab.this.selectQuery));
        }
    }
}

