/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateDbEntityUndoableEdit
extends CayenneUndoableEdit {
    private DataMap map;
    private DbEntity entity;

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Create DbEntity";
    }

    public CreateDbEntityUndoableEdit(DataMap map, DbEntity entity) {
        this.map = map;
        this.entity = entity;
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateDbEntityAction action = this.actionManager.getAction(CreateDbEntityAction.class);
        action.createEntity(this.map, this.entity);
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveAction action = this.actionManager.getAction(RemoveAction.class);
        action.removeDbEntity(this.map, this.entity);
    }
}

